package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSRecordListBuilder extends DNSRecordListFluent<DNSRecordListBuilder> implements VisitableBuilder<DNSRecordList,DNSRecordListBuilder>{
  public DNSRecordListBuilder() {
    this(false);
  }
  public DNSRecordListBuilder(Boolean validationEnabled) {
    this(new DNSRecordList(), validationEnabled);
  }
  public DNSRecordListBuilder(DNSRecordListFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSRecordListBuilder(DNSRecordListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSRecordList(), validationEnabled);
  }
  public DNSRecordListBuilder(DNSRecordListFluent<?> fluent,DNSRecordList instance) {
    this(fluent, instance, false);
  }
  public DNSRecordListBuilder(DNSRecordListFluent<?> fluent,DNSRecordList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSRecordList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSRecordListBuilder(DNSRecordList instance) {
    this(instance,false);
  }
  public DNSRecordListBuilder(DNSRecordList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSRecordList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSRecordListFluent<?> fluent;
  Boolean validationEnabled;
  public DNSRecordList build() {
    DNSRecordList buildable = new DNSRecordList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}