package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSCacheBuilder extends DNSCacheFluent<DNSCacheBuilder> implements VisitableBuilder<DNSCache,DNSCacheBuilder>{
  public DNSCacheBuilder() {
    this(false);
  }
  public DNSCacheBuilder(Boolean validationEnabled) {
    this(new DNSCache(), validationEnabled);
  }
  public DNSCacheBuilder(DNSCacheFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSCacheBuilder(DNSCacheFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSCache(), validationEnabled);
  }
  public DNSCacheBuilder(DNSCacheFluent<?> fluent,DNSCache instance) {
    this(fluent, instance, false);
  }
  public DNSCacheBuilder(DNSCacheFluent<?> fluent,DNSCache instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSCache());

    if (instance != null) {
      fluent.withNegativeTTL(instance.getNegativeTTL());
      fluent.withPositiveTTL(instance.getPositiveTTL());
      fluent.withNegativeTTL(instance.getNegativeTTL());
      fluent.withPositiveTTL(instance.getPositiveTTL());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSCacheBuilder(DNSCache instance) {
    this(instance,false);
  }
  public DNSCacheBuilder(DNSCache instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSCache());

    if (instance != null) {
      this.withNegativeTTL(instance.getNegativeTTL());
      this.withPositiveTTL(instance.getPositiveTTL());
      this.withNegativeTTL(instance.getNegativeTTL());
      this.withPositiveTTL(instance.getPositiveTTL());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSCacheFluent<?> fluent;
  Boolean validationEnabled;
  public DNSCache build() {
    DNSCache buildable = new DNSCache(fluent.getNegativeTTL(),fluent.getPositiveTTL());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}