package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleSpecBuilder extends ConsoleSpecFluent<ConsoleSpecBuilder> implements VisitableBuilder<ConsoleSpec,ConsoleSpecBuilder>{
  public ConsoleSpecBuilder() {
    this(false);
  }
  public ConsoleSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleSpec(), validationEnabled);
  }
  public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleSpec(), validationEnabled);
  }
  public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent,ConsoleSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent,ConsoleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsoleSpec());

    if (instance != null) {
      fluent.withCustomization(instance.getCustomization());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withPlugins(instance.getPlugins());
      fluent.withProviders(instance.getProviders());
      fluent.withRoute(instance.getRoute());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withCustomization(instance.getCustomization());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withPlugins(instance.getPlugins());
      fluent.withProviders(instance.getProviders());
      fluent.withRoute(instance.getRoute());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleSpecBuilder(ConsoleSpec instance) {
    this(instance,false);
  }
  public ConsoleSpecBuilder(ConsoleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsoleSpec());

    if (instance != null) {
      this.withCustomization(instance.getCustomization());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withPlugins(instance.getPlugins());
      this.withProviders(instance.getProviders());
      this.withRoute(instance.getRoute());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withCustomization(instance.getCustomization());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withPlugins(instance.getPlugins());
      this.withProviders(instance.getProviders());
      this.withRoute(instance.getRoute());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleSpec build() {
    ConsoleSpec buildable = new ConsoleSpec(fluent.buildCustomization(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.getPlugins(),fluent.buildProviders(),fluent.buildRoute(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}