package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigSpecBuilder extends ConfigSpecFluent<ConfigSpecBuilder> implements VisitableBuilder<ConfigSpec,ConfigSpecBuilder>{
  public ConfigSpecBuilder() {
    this(false);
  }
  public ConfigSpecBuilder(Boolean validationEnabled) {
    this(new ConfigSpec(), validationEnabled);
  }
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigSpec(), validationEnabled);
  }
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent,ConfigSpec instance) {
    this(fluent, instance, false);
  }
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent,ConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConfigSpec());

    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigSpecBuilder(ConfigSpec instance) {
    this(instance,false);
  }
  public ConfigSpecBuilder(ConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConfigSpec());

    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigSpec build() {
    ConfigSpec buildable = new ConfigSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}