package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigBuilder extends ConfigFluent<ConfigBuilder> implements VisitableBuilder<Config,ConfigBuilder>{
  public ConfigBuilder() {
    this(false);
  }
  public ConfigBuilder(Boolean validationEnabled) {
    this(new Config(), validationEnabled);
  }
  public ConfigBuilder(ConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Config(), validationEnabled);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Config instance) {
    this(fluent, instance, false);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Config instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Config());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigBuilder(Config instance) {
    this(instance,false);
  }
  public ConfigBuilder(Config instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Config());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigFluent<?> fluent;
  Boolean validationEnabled;
  public Config build() {
    Config buildable = new Config(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}