package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterCSIDriverSpecBuilder extends ClusterCSIDriverSpecFluent<ClusterCSIDriverSpecBuilder> implements VisitableBuilder<ClusterCSIDriverSpec,ClusterCSIDriverSpecBuilder>{
  public ClusterCSIDriverSpecBuilder() {
    this(false);
  }
  public ClusterCSIDriverSpecBuilder(Boolean validationEnabled) {
    this(new ClusterCSIDriverSpec(), validationEnabled);
  }
  public ClusterCSIDriverSpecBuilder(ClusterCSIDriverSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterCSIDriverSpecBuilder(ClusterCSIDriverSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterCSIDriverSpec(), validationEnabled);
  }
  public ClusterCSIDriverSpecBuilder(ClusterCSIDriverSpecFluent<?> fluent,ClusterCSIDriverSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterCSIDriverSpecBuilder(ClusterCSIDriverSpecFluent<?> fluent,ClusterCSIDriverSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterCSIDriverSpec());

    if (instance != null) {
      fluent.withDriverConfig(instance.getDriverConfig());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withStorageClassState(instance.getStorageClassState());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withDriverConfig(instance.getDriverConfig());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withStorageClassState(instance.getStorageClassState());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterCSIDriverSpecBuilder(ClusterCSIDriverSpec instance) {
    this(instance,false);
  }
  public ClusterCSIDriverSpecBuilder(ClusterCSIDriverSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterCSIDriverSpec());

    if (instance != null) {
      this.withDriverConfig(instance.getDriverConfig());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withStorageClassState(instance.getStorageClassState());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withDriverConfig(instance.getDriverConfig());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withStorageClassState(instance.getStorageClassState());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterCSIDriverSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterCSIDriverSpec build() {
    ClusterCSIDriverSpec buildable = new ClusterCSIDriverSpec(fluent.buildDriverConfig(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.getStorageClassState(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}