package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CloudCredentialSpecBuilder extends CloudCredentialSpecFluent<CloudCredentialSpecBuilder> implements VisitableBuilder<CloudCredentialSpec,CloudCredentialSpecBuilder>{
  public CloudCredentialSpecBuilder() {
    this(false);
  }
  public CloudCredentialSpecBuilder(Boolean validationEnabled) {
    this(new CloudCredentialSpec(), validationEnabled);
  }
  public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CloudCredentialSpec(), validationEnabled);
  }
  public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent,CloudCredentialSpec instance) {
    this(fluent, instance, false);
  }
  public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent,CloudCredentialSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CloudCredentialSpec());

    if (instance != null) {
      fluent.withCredentialsMode(instance.getCredentialsMode());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withCredentialsMode(instance.getCredentialsMode());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CloudCredentialSpecBuilder(CloudCredentialSpec instance) {
    this(instance,false);
  }
  public CloudCredentialSpecBuilder(CloudCredentialSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CloudCredentialSpec());

    if (instance != null) {
      this.withCredentialsMode(instance.getCredentialsMode());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withCredentialsMode(instance.getCredentialsMode());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CloudCredentialSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CloudCredentialSpec build() {
    CloudCredentialSpec buildable = new CloudCredentialSpec(fluent.getCredentialsMode(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}