package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CloudCredentialListBuilder extends CloudCredentialListFluent<CloudCredentialListBuilder> implements VisitableBuilder<CloudCredentialList,CloudCredentialListBuilder>{
  public CloudCredentialListBuilder() {
    this(false);
  }
  public CloudCredentialListBuilder(Boolean validationEnabled) {
    this(new CloudCredentialList(), validationEnabled);
  }
  public CloudCredentialListBuilder(CloudCredentialListFluent<?> fluent) {
    this(fluent, false);
  }
  public CloudCredentialListBuilder(CloudCredentialListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CloudCredentialList(), validationEnabled);
  }
  public CloudCredentialListBuilder(CloudCredentialListFluent<?> fluent,CloudCredentialList instance) {
    this(fluent, instance, false);
  }
  public CloudCredentialListBuilder(CloudCredentialListFluent<?> fluent,CloudCredentialList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CloudCredentialList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CloudCredentialListBuilder(CloudCredentialList instance) {
    this(instance,false);
  }
  public CloudCredentialListBuilder(CloudCredentialList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CloudCredentialList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CloudCredentialListFluent<?> fluent;
  Boolean validationEnabled;
  public CloudCredentialList build() {
    CloudCredentialList buildable = new CloudCredentialList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}