package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CloudCredentialBuilder extends CloudCredentialFluent<CloudCredentialBuilder> implements VisitableBuilder<CloudCredential,CloudCredentialBuilder>{
  public CloudCredentialBuilder() {
    this(false);
  }
  public CloudCredentialBuilder(Boolean validationEnabled) {
    this(new CloudCredential(), validationEnabled);
  }
  public CloudCredentialBuilder(CloudCredentialFluent<?> fluent) {
    this(fluent, false);
  }
  public CloudCredentialBuilder(CloudCredentialFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CloudCredential(), validationEnabled);
  }
  public CloudCredentialBuilder(CloudCredentialFluent<?> fluent,CloudCredential instance) {
    this(fluent, instance, false);
  }
  public CloudCredentialBuilder(CloudCredentialFluent<?> fluent,CloudCredential instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CloudCredential());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CloudCredentialBuilder(CloudCredential instance) {
    this(instance,false);
  }
  public CloudCredentialBuilder(CloudCredential instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CloudCredential());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CloudCredentialFluent<?> fluent;
  Boolean validationEnabled;
  public CloudCredential build() {
    CloudCredential buildable = new CloudCredential(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}