package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSISnapshotControllerSpecBuilder extends CSISnapshotControllerSpecFluent<CSISnapshotControllerSpecBuilder> implements VisitableBuilder<CSISnapshotControllerSpec,CSISnapshotControllerSpecBuilder>{
  public CSISnapshotControllerSpecBuilder() {
    this(false);
  }
  public CSISnapshotControllerSpecBuilder(Boolean validationEnabled) {
    this(new CSISnapshotControllerSpec(), validationEnabled);
  }
  public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSISnapshotControllerSpec(), validationEnabled);
  }
  public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpecFluent<?> fluent,CSISnapshotControllerSpec instance) {
    this(fluent, instance, false);
  }
  public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpecFluent<?> fluent,CSISnapshotControllerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CSISnapshotControllerSpec());

    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpec instance) {
    this(instance,false);
  }
  public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CSISnapshotControllerSpec());

    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CSISnapshotControllerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CSISnapshotControllerSpec build() {
    CSISnapshotControllerSpec buildable = new CSISnapshotControllerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}