package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSIDriverConfigSpecBuilder extends CSIDriverConfigSpecFluent<CSIDriverConfigSpecBuilder> implements VisitableBuilder<CSIDriverConfigSpec,CSIDriverConfigSpecBuilder>{
  public CSIDriverConfigSpecBuilder() {
    this(false);
  }
  public CSIDriverConfigSpecBuilder(Boolean validationEnabled) {
    this(new CSIDriverConfigSpec(), validationEnabled);
  }
  public CSIDriverConfigSpecBuilder(CSIDriverConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIDriverConfigSpecBuilder(CSIDriverConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSIDriverConfigSpec(), validationEnabled);
  }
  public CSIDriverConfigSpecBuilder(CSIDriverConfigSpecFluent<?> fluent,CSIDriverConfigSpec instance) {
    this(fluent, instance, false);
  }
  public CSIDriverConfigSpecBuilder(CSIDriverConfigSpecFluent<?> fluent,CSIDriverConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CSIDriverConfigSpec());

    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withDriverType(instance.getDriverType());
      fluent.withGcp(instance.getGcp());
      fluent.withVSphere(instance.getVSphere());
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withDriverType(instance.getDriverType());
      fluent.withGcp(instance.getGcp());
      fluent.withVSphere(instance.getVSphere());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CSIDriverConfigSpecBuilder(CSIDriverConfigSpec instance) {
    this(instance,false);
  }
  public CSIDriverConfigSpecBuilder(CSIDriverConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CSIDriverConfigSpec());

    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withDriverType(instance.getDriverType());
      this.withGcp(instance.getGcp());
      this.withVSphere(instance.getVSphere());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withDriverType(instance.getDriverType());
      this.withGcp(instance.getGcp());
      this.withVSphere(instance.getVSphere());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CSIDriverConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CSIDriverConfigSpec build() {
    CSIDriverConfigSpec buildable = new CSIDriverConfigSpec(fluent.buildAws(),fluent.buildAzure(),fluent.getDriverType(),fluent.buildGcp(),fluent.buildVSphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}