package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AccessLoggingBuilder extends AccessLoggingFluent<AccessLoggingBuilder> implements VisitableBuilder<AccessLogging,AccessLoggingBuilder>{
  public AccessLoggingBuilder() {
    this(false);
  }
  public AccessLoggingBuilder(Boolean validationEnabled) {
    this(new AccessLogging(), validationEnabled);
  }
  public AccessLoggingBuilder(AccessLoggingFluent<?> fluent) {
    this(fluent, false);
  }
  public AccessLoggingBuilder(AccessLoggingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AccessLogging(), validationEnabled);
  }
  public AccessLoggingBuilder(AccessLoggingFluent<?> fluent,AccessLogging instance) {
    this(fluent, instance, false);
  }
  public AccessLoggingBuilder(AccessLoggingFluent<?> fluent,AccessLogging instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AccessLogging());

    if (instance != null) {
      fluent.withDestination(instance.getDestination());
      fluent.withHttpCaptureCookies(instance.getHttpCaptureCookies());
      fluent.withHttpCaptureHeaders(instance.getHttpCaptureHeaders());
      fluent.withHttpLogFormat(instance.getHttpLogFormat());
      fluent.withLogEmptyRequests(instance.getLogEmptyRequests());
      fluent.withDestination(instance.getDestination());
      fluent.withHttpCaptureCookies(instance.getHttpCaptureCookies());
      fluent.withHttpCaptureHeaders(instance.getHttpCaptureHeaders());
      fluent.withHttpLogFormat(instance.getHttpLogFormat());
      fluent.withLogEmptyRequests(instance.getLogEmptyRequests());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AccessLoggingBuilder(AccessLogging instance) {
    this(instance,false);
  }
  public AccessLoggingBuilder(AccessLogging instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AccessLogging());

    if (instance != null) {
      this.withDestination(instance.getDestination());
      this.withHttpCaptureCookies(instance.getHttpCaptureCookies());
      this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders());
      this.withHttpLogFormat(instance.getHttpLogFormat());
      this.withLogEmptyRequests(instance.getLogEmptyRequests());
      this.withDestination(instance.getDestination());
      this.withHttpCaptureCookies(instance.getHttpCaptureCookies());
      this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders());
      this.withHttpLogFormat(instance.getHttpLogFormat());
      this.withLogEmptyRequests(instance.getLogEmptyRequests());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AccessLoggingFluent<?> fluent;
  Boolean validationEnabled;
  public AccessLogging build() {
    AccessLogging buildable = new AccessLogging(fluent.buildDestination(),fluent.buildHttpCaptureCookies(),fluent.buildHttpCaptureHeaders(),fluent.getHttpLogFormat(),fluent.getLogEmptyRequests());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}