package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodNetworkConnectivityCheckBuilder extends PodNetworkConnectivityCheckFluent<PodNetworkConnectivityCheckBuilder> implements VisitableBuilder<PodNetworkConnectivityCheck,PodNetworkConnectivityCheckBuilder>{
  public PodNetworkConnectivityCheckBuilder() {
    this(false);
  }
  public PodNetworkConnectivityCheckBuilder(Boolean validationEnabled) {
    this(new PodNetworkConnectivityCheck(), validationEnabled);
  }
  public PodNetworkConnectivityCheckBuilder(PodNetworkConnectivityCheckFluent<?> fluent) {
    this(fluent, false);
  }
  public PodNetworkConnectivityCheckBuilder(PodNetworkConnectivityCheckFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodNetworkConnectivityCheck(), validationEnabled);
  }
  public PodNetworkConnectivityCheckBuilder(PodNetworkConnectivityCheckFluent<?> fluent,PodNetworkConnectivityCheck instance) {
    this(fluent, instance, false);
  }
  public PodNetworkConnectivityCheckBuilder(PodNetworkConnectivityCheckFluent<?> fluent,PodNetworkConnectivityCheck instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodNetworkConnectivityCheck());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodNetworkConnectivityCheckBuilder(PodNetworkConnectivityCheck instance) {
    this(instance,false);
  }
  public PodNetworkConnectivityCheckBuilder(PodNetworkConnectivityCheck instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodNetworkConnectivityCheck());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodNetworkConnectivityCheckFluent<?> fluent;
  Boolean validationEnabled;
  public PodNetworkConnectivityCheck build() {
    PodNetworkConnectivityCheck buildable = new PodNetworkConnectivityCheck(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}