package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCatalogAPIServerListBuilder extends ServiceCatalogAPIServerListFluentImpl<ServiceCatalogAPIServerListBuilder> implements VisitableBuilder<ServiceCatalogAPIServerList,ServiceCatalogAPIServerListBuilder>{
  public ServiceCatalogAPIServerListBuilder() {
    this(false);
  }
  public ServiceCatalogAPIServerListBuilder(Boolean validationEnabled) {
    this(new ServiceCatalogAPIServerList(), validationEnabled);
  }
  public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCatalogAPIServerList(), validationEnabled);
  }
  public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerListFluent<?> fluent,ServiceCatalogAPIServerList instance) {
    this(fluent, instance, false);
  }
  public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerListFluent<?> fluent,ServiceCatalogAPIServerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerList instance) {
    this(instance,false);
  }
  public ServiceCatalogAPIServerListBuilder(ServiceCatalogAPIServerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceCatalogAPIServerListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCatalogAPIServerList build() {
    ServiceCatalogAPIServerList buildable = new ServiceCatalogAPIServerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}