package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenShiftSDNConfigBuilder extends OpenShiftSDNConfigFluentImpl<OpenShiftSDNConfigBuilder> implements VisitableBuilder<OpenShiftSDNConfig,OpenShiftSDNConfigBuilder>{
  public OpenShiftSDNConfigBuilder() {
    this(false);
  }
  public OpenShiftSDNConfigBuilder(Boolean validationEnabled) {
    this(new OpenShiftSDNConfig(), validationEnabled);
  }
  public OpenShiftSDNConfigBuilder(OpenShiftSDNConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftSDNConfigBuilder(OpenShiftSDNConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenShiftSDNConfig(), validationEnabled);
  }
  public OpenShiftSDNConfigBuilder(OpenShiftSDNConfigFluent<?> fluent,OpenShiftSDNConfig instance) {
    this(fluent, instance, false);
  }
  public OpenShiftSDNConfigBuilder(OpenShiftSDNConfigFluent<?> fluent,OpenShiftSDNConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEnableUnidling(instance.getEnableUnidling()); 
    fluent.withMode(instance.getMode()); 
    fluent.withMtu(instance.getMtu()); 
    fluent.withUseExternalOpenvswitch(instance.getUseExternalOpenvswitch()); 
    fluent.withVxlanPort(instance.getVxlanPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftSDNConfigBuilder(OpenShiftSDNConfig instance) {
    this(instance,false);
  }
  public OpenShiftSDNConfigBuilder(OpenShiftSDNConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEnableUnidling(instance.getEnableUnidling()); 
    this.withMode(instance.getMode()); 
    this.withMtu(instance.getMtu()); 
    this.withUseExternalOpenvswitch(instance.getUseExternalOpenvswitch()); 
    this.withVxlanPort(instance.getVxlanPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OpenShiftSDNConfigFluent<?> fluent;
  Boolean validationEnabled;
  public OpenShiftSDNConfig build() {
    OpenShiftSDNConfig buildable = new OpenShiftSDNConfig(fluent.getEnableUnidling(),fluent.getMode(),fluent.getMtu(),fluent.getUseExternalOpenvswitch(),fluent.getVxlanPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}