package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenShiftControllerManagerBuilder extends OpenShiftControllerManagerFluentImpl<OpenShiftControllerManagerBuilder> implements VisitableBuilder<OpenShiftControllerManager,OpenShiftControllerManagerBuilder>{
  public OpenShiftControllerManagerBuilder() {
    this(false);
  }
  public OpenShiftControllerManagerBuilder(Boolean validationEnabled) {
    this(new OpenShiftControllerManager(), validationEnabled);
  }
  public OpenShiftControllerManagerBuilder(OpenShiftControllerManagerFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftControllerManagerBuilder(OpenShiftControllerManagerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenShiftControllerManager(), validationEnabled);
  }
  public OpenShiftControllerManagerBuilder(OpenShiftControllerManagerFluent<?> fluent,OpenShiftControllerManager instance) {
    this(fluent, instance, false);
  }
  public OpenShiftControllerManagerBuilder(OpenShiftControllerManagerFluent<?> fluent,OpenShiftControllerManager instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftControllerManagerBuilder(OpenShiftControllerManager instance) {
    this(instance,false);
  }
  public OpenShiftControllerManagerBuilder(OpenShiftControllerManager instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OpenShiftControllerManagerFluent<?> fluent;
  Boolean validationEnabled;
  public OpenShiftControllerManager build() {
    OpenShiftControllerManager buildable = new OpenShiftControllerManager(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}