package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetFlowConfigBuilder extends NetFlowConfigFluentImpl<NetFlowConfigBuilder> implements VisitableBuilder<NetFlowConfig,NetFlowConfigBuilder>{
  public NetFlowConfigBuilder() {
    this(false);
  }
  public NetFlowConfigBuilder(Boolean validationEnabled) {
    this(new NetFlowConfig(), validationEnabled);
  }
  public NetFlowConfigBuilder(NetFlowConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public NetFlowConfigBuilder(NetFlowConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetFlowConfig(), validationEnabled);
  }
  public NetFlowConfigBuilder(NetFlowConfigFluent<?> fluent,NetFlowConfig instance) {
    this(fluent, instance, false);
  }
  public NetFlowConfigBuilder(NetFlowConfigFluent<?> fluent,NetFlowConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCollectors(instance.getCollectors()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetFlowConfigBuilder(NetFlowConfig instance) {
    this(instance,false);
  }
  public NetFlowConfigBuilder(NetFlowConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCollectors(instance.getCollectors()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NetFlowConfigFluent<?> fluent;
  Boolean validationEnabled;
  public NetFlowConfig build() {
    NetFlowConfig buildable = new NetFlowConfig(fluent.getCollectors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}