package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KuryrConfigBuilder extends KuryrConfigFluentImpl<KuryrConfigBuilder> implements VisitableBuilder<KuryrConfig,KuryrConfigBuilder>{
  public KuryrConfigBuilder() {
    this(false);
  }
  public KuryrConfigBuilder(Boolean validationEnabled) {
    this(new KuryrConfig(), validationEnabled);
  }
  public KuryrConfigBuilder(KuryrConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public KuryrConfigBuilder(KuryrConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KuryrConfig(), validationEnabled);
  }
  public KuryrConfigBuilder(KuryrConfigFluent<?> fluent,KuryrConfig instance) {
    this(fluent, instance, false);
  }
  public KuryrConfigBuilder(KuryrConfigFluent<?> fluent,KuryrConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withControllerProbesPort(instance.getControllerProbesPort()); 
    fluent.withDaemonProbesPort(instance.getDaemonProbesPort()); 
    fluent.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation()); 
    fluent.withMtu(instance.getMtu()); 
    fluent.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork()); 
    fluent.withPoolBatchPorts(instance.getPoolBatchPorts()); 
    fluent.withPoolMaxPorts(instance.getPoolMaxPorts()); 
    fluent.withPoolMinPorts(instance.getPoolMinPorts()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KuryrConfigBuilder(KuryrConfig instance) {
    this(instance,false);
  }
  public KuryrConfigBuilder(KuryrConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withControllerProbesPort(instance.getControllerProbesPort()); 
    this.withDaemonProbesPort(instance.getDaemonProbesPort()); 
    this.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation()); 
    this.withMtu(instance.getMtu()); 
    this.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork()); 
    this.withPoolBatchPorts(instance.getPoolBatchPorts()); 
    this.withPoolMaxPorts(instance.getPoolMaxPorts()); 
    this.withPoolMinPorts(instance.getPoolMinPorts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KuryrConfigFluent<?> fluent;
  Boolean validationEnabled;
  public KuryrConfig build() {
    KuryrConfig buildable = new KuryrConfig(fluent.getControllerProbesPort(),fluent.getDaemonProbesPort(),fluent.getEnablePortPoolsPrepopulation(),fluent.getMtu(),fluent.getOpenStackServiceNetwork(),fluent.getPoolBatchPorts(),fluent.getPoolMaxPorts(),fluent.getPoolMinPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}