package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeStorageVersionMigratorBuilder extends KubeStorageVersionMigratorFluentImpl<KubeStorageVersionMigratorBuilder> implements VisitableBuilder<KubeStorageVersionMigrator,KubeStorageVersionMigratorBuilder>{
  public KubeStorageVersionMigratorBuilder() {
    this(false);
  }
  public KubeStorageVersionMigratorBuilder(Boolean validationEnabled) {
    this(new KubeStorageVersionMigrator(), validationEnabled);
  }
  public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigratorFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigratorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeStorageVersionMigrator(), validationEnabled);
  }
  public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigratorFluent<?> fluent,KubeStorageVersionMigrator instance) {
    this(fluent, instance, false);
  }
  public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigratorFluent<?> fluent,KubeStorageVersionMigrator instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigrator instance) {
    this(instance,false);
  }
  public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigrator instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KubeStorageVersionMigratorFluent<?> fluent;
  Boolean validationEnabled;
  public KubeStorageVersionMigrator build() {
    KubeStorageVersionMigrator buildable = new KubeStorageVersionMigrator(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}