package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCatalogAPIServerStatusBuilder extends ServiceCatalogAPIServerStatusFluentImpl<ServiceCatalogAPIServerStatusBuilder> implements VisitableBuilder<ServiceCatalogAPIServerStatus,ServiceCatalogAPIServerStatusBuilder>{
  public ServiceCatalogAPIServerStatusBuilder() {
    this(false);
  }
  public ServiceCatalogAPIServerStatusBuilder(Boolean validationEnabled) {
    this(new ServiceCatalogAPIServerStatus(), validationEnabled);
  }
  public ServiceCatalogAPIServerStatusBuilder(ServiceCatalogAPIServerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCatalogAPIServerStatusBuilder(ServiceCatalogAPIServerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCatalogAPIServerStatus(), validationEnabled);
  }
  public ServiceCatalogAPIServerStatusBuilder(ServiceCatalogAPIServerStatusFluent<?> fluent,ServiceCatalogAPIServerStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceCatalogAPIServerStatusBuilder(ServiceCatalogAPIServerStatusFluent<?> fluent,ServiceCatalogAPIServerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withGenerations(instance.getGenerations()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyReplicas(instance.getReadyReplicas()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceCatalogAPIServerStatusBuilder(ServiceCatalogAPIServerStatus instance) {
    this(instance,false);
  }
  public ServiceCatalogAPIServerStatusBuilder(ServiceCatalogAPIServerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withGenerations(instance.getGenerations()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceCatalogAPIServerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCatalogAPIServerStatus build() {
    ServiceCatalogAPIServerStatus buildable = new ServiceCatalogAPIServerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}