package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenShiftAPIServerListBuilder extends OpenShiftAPIServerListFluentImpl<OpenShiftAPIServerListBuilder> implements VisitableBuilder<OpenShiftAPIServerList,OpenShiftAPIServerListBuilder>{
  public OpenShiftAPIServerListBuilder() {
    this(false);
  }
  public OpenShiftAPIServerListBuilder(Boolean validationEnabled) {
    this(new OpenShiftAPIServerList(), validationEnabled);
  }
  public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenShiftAPIServerList(), validationEnabled);
  }
  public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent,OpenShiftAPIServerList instance) {
    this(fluent, instance, false);
  }
  public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent,OpenShiftAPIServerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftAPIServerListBuilder(OpenShiftAPIServerList instance) {
    this(instance,false);
  }
  public OpenShiftAPIServerListBuilder(OpenShiftAPIServerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OpenShiftAPIServerListFluent<?> fluent;
  Boolean validationEnabled;
  public OpenShiftAPIServerList build() {
    OpenShiftAPIServerList buildable = new OpenShiftAPIServerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}