package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressControllerLoggingBuilder extends IngressControllerLoggingFluentImpl<IngressControllerLoggingBuilder> implements VisitableBuilder<IngressControllerLogging,IngressControllerLoggingBuilder>{
  public IngressControllerLoggingBuilder() {
    this(false);
  }
  public IngressControllerLoggingBuilder(Boolean validationEnabled) {
    this(new IngressControllerLogging(), validationEnabled);
  }
  public IngressControllerLoggingBuilder(IngressControllerLoggingFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressControllerLoggingBuilder(IngressControllerLoggingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressControllerLogging(), validationEnabled);
  }
  public IngressControllerLoggingBuilder(IngressControllerLoggingFluent<?> fluent,IngressControllerLogging instance) {
    this(fluent, instance, false);
  }
  public IngressControllerLoggingBuilder(IngressControllerLoggingFluent<?> fluent,IngressControllerLogging instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAccess(instance.getAccess()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressControllerLoggingBuilder(IngressControllerLogging instance) {
    this(instance,false);
  }
  public IngressControllerLoggingBuilder(IngressControllerLogging instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAccess(instance.getAccess()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressControllerLoggingFluent<?> fluent;
  Boolean validationEnabled;
  public IngressControllerLogging build() {
    IngressControllerLogging buildable = new IngressControllerLogging(fluent.getAccess());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}