package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageListBuilder extends StorageListFluentImpl<StorageListBuilder> implements VisitableBuilder<StorageList,StorageListBuilder>{
  public StorageListBuilder() {
    this(false);
  }
  public StorageListBuilder(Boolean validationEnabled) {
    this(new StorageList(), validationEnabled);
  }
  public StorageListBuilder(StorageListFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageListBuilder(StorageListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageList(), validationEnabled);
  }
  public StorageListBuilder(StorageListFluent<?> fluent,StorageList instance) {
    this(fluent, instance, false);
  }
  public StorageListBuilder(StorageListFluent<?> fluent,StorageList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StorageListBuilder(StorageList instance) {
    this(instance,false);
  }
  public StorageListBuilder(StorageList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StorageListFluent<?> fluent;
  Boolean validationEnabled;
  public StorageList build() {
    StorageList buildable = new StorageList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}