package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorConditionBuilder extends OperatorConditionFluentImpl<OperatorConditionBuilder> implements VisitableBuilder<OperatorCondition,OperatorConditionBuilder>{
  public OperatorConditionBuilder() {
    this(false);
  }
  public OperatorConditionBuilder(Boolean validationEnabled) {
    this(new OperatorCondition(), validationEnabled);
  }
  public OperatorConditionBuilder(OperatorConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorConditionBuilder(OperatorConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorCondition(), validationEnabled);
  }
  public OperatorConditionBuilder(OperatorConditionFluent<?> fluent,OperatorCondition instance) {
    this(fluent, instance, false);
  }
  public OperatorConditionBuilder(OperatorConditionFluent<?> fluent,OperatorCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorConditionBuilder(OperatorCondition instance) {
    this(instance,false);
  }
  public OperatorConditionBuilder(OperatorCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperatorConditionFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorCondition build() {
    OperatorCondition buildable = new OperatorCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}