package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressControllerStatusBuilder extends IngressControllerStatusFluentImpl<IngressControllerStatusBuilder> implements VisitableBuilder<IngressControllerStatus,IngressControllerStatusBuilder>{
  public IngressControllerStatusBuilder() {
    this(false);
  }
  public IngressControllerStatusBuilder(Boolean validationEnabled) {
    this(new IngressControllerStatus(), validationEnabled);
  }
  public IngressControllerStatusBuilder(IngressControllerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressControllerStatusBuilder(IngressControllerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressControllerStatus(), validationEnabled);
  }
  public IngressControllerStatusBuilder(IngressControllerStatusFluent<?> fluent,IngressControllerStatus instance) {
    this(fluent, instance, false);
  }
  public IngressControllerStatusBuilder(IngressControllerStatusFluent<?> fluent,IngressControllerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withDomain(instance.getDomain()); 
    fluent.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTlsProfile(instance.getTlsProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressControllerStatusBuilder(IngressControllerStatus instance) {
    this(instance,false);
  }
  public IngressControllerStatusBuilder(IngressControllerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withConditions(instance.getConditions()); 
    this.withDomain(instance.getDomain()); 
    this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSelector(instance.getSelector()); 
    this.withTlsProfile(instance.getTlsProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressControllerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IngressControllerStatus build() {
    IngressControllerStatus buildable = new IngressControllerStatus(fluent.getAvailableReplicas(),fluent.getConditions(),fluent.getDomain(),fluent.getEndpointPublishingStrategy(),fluent.getObservedGeneration(),fluent.getSelector(),fluent.getTlsProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}