package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImagePrunerSpecBuilder extends ImagePrunerSpecFluentImpl<ImagePrunerSpecBuilder> implements VisitableBuilder<ImagePrunerSpec,ImagePrunerSpecBuilder>{
  public ImagePrunerSpecBuilder() {
    this(false);
  }
  public ImagePrunerSpecBuilder(Boolean validationEnabled) {
    this(new ImagePrunerSpec(), validationEnabled);
  }
  public ImagePrunerSpecBuilder(ImagePrunerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImagePrunerSpecBuilder(ImagePrunerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImagePrunerSpec(), validationEnabled);
  }
  public ImagePrunerSpecBuilder(ImagePrunerSpecFluent<?> fluent,ImagePrunerSpec instance) {
    this(fluent, instance, false);
  }
  public ImagePrunerSpecBuilder(ImagePrunerSpecFluent<?> fluent,ImagePrunerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAffinity(instance.getAffinity()); 
    fluent.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit()); 
    fluent.withIgnoreInvalidImageReferences(instance.getIgnoreInvalidImageReferences()); 
    fluent.withKeepTagRevisions(instance.getKeepTagRevisions()); 
    fluent.withKeepYoungerThan(instance.getKeepYoungerThan()); 
    fluent.withKeepYoungerThanDuration(instance.getKeepYoungerThanDuration()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withResources(instance.getResources()); 
    fluent.withSchedule(instance.getSchedule()); 
    fluent.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit()); 
    fluent.withSuspend(instance.getSuspend()); 
    fluent.withTolerations(instance.getTolerations()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImagePrunerSpecBuilder(ImagePrunerSpec instance) {
    this(instance,false);
  }
  public ImagePrunerSpecBuilder(ImagePrunerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAffinity(instance.getAffinity()); 
    this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit()); 
    this.withIgnoreInvalidImageReferences(instance.getIgnoreInvalidImageReferences()); 
    this.withKeepTagRevisions(instance.getKeepTagRevisions()); 
    this.withKeepYoungerThan(instance.getKeepYoungerThan()); 
    this.withKeepYoungerThanDuration(instance.getKeepYoungerThanDuration()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withResources(instance.getResources()); 
    this.withSchedule(instance.getSchedule()); 
    this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit()); 
    this.withSuspend(instance.getSuspend()); 
    this.withTolerations(instance.getTolerations()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImagePrunerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ImagePrunerSpec build() {
    ImagePrunerSpec buildable = new ImagePrunerSpec(fluent.getAffinity(),fluent.getFailedJobsHistoryLimit(),fluent.getIgnoreInvalidImageReferences(),fluent.getKeepTagRevisions(),fluent.getKeepYoungerThan(),fluent.getKeepYoungerThanDuration(),fluent.getLogLevel(),fluent.getNodeSelector(),fluent.getResources(),fluent.getSchedule(),fluent.getSuccessfulJobsHistoryLimit(),fluent.getSuspend(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}