package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerStrategyBuilder extends LoadBalancerStrategyFluentImpl<LoadBalancerStrategyBuilder> implements VisitableBuilder<LoadBalancerStrategy,LoadBalancerStrategyBuilder>{
  public LoadBalancerStrategyBuilder() {
    this(false);
  }
  public LoadBalancerStrategyBuilder(Boolean validationEnabled) {
    this(new LoadBalancerStrategy(), validationEnabled);
  }
  public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LoadBalancerStrategy(), validationEnabled);
  }
  public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent,LoadBalancerStrategy instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent,LoadBalancerStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withProviderParameters(instance.getProviderParameters()); 
    fluent.withScope(instance.getScope()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerStrategyBuilder(LoadBalancerStrategy instance) {
    this(instance,false);
  }
  public LoadBalancerStrategyBuilder(LoadBalancerStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withProviderParameters(instance.getProviderParameters()); 
    this.withScope(instance.getScope()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  LoadBalancerStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public LoadBalancerStrategy build() {
    LoadBalancerStrategy buildable = new LoadBalancerStrategy(fluent.getProviderParameters(),fluent.getScope());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}