package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeAPIServerBuilder extends KubeAPIServerFluentImpl<KubeAPIServerBuilder> implements VisitableBuilder<KubeAPIServer,KubeAPIServerBuilder>{
  public KubeAPIServerBuilder() {
    this(false);
  }
  public KubeAPIServerBuilder(Boolean validationEnabled) {
    this(new KubeAPIServer(), validationEnabled);
  }
  public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeAPIServer(), validationEnabled);
  }
  public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent,KubeAPIServer instance) {
    this(fluent, instance, false);
  }
  public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent,KubeAPIServer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubeAPIServerBuilder(KubeAPIServer instance) {
    this(instance,false);
  }
  public KubeAPIServerBuilder(KubeAPIServer instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KubeAPIServerFluent<?> fluent;
  Boolean validationEnabled;
  public KubeAPIServer build() {
    KubeAPIServer buildable = new KubeAPIServer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}