package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DeveloperConsoleCatalogCategoryMetaFluentImpl<A extends DeveloperConsoleCatalogCategoryMetaFluent<A>> extends BaseFluent<A> implements DeveloperConsoleCatalogCategoryMetaFluent<A>{
  public DeveloperConsoleCatalogCategoryMetaFluentImpl() {
  }
  public DeveloperConsoleCatalogCategoryMetaFluentImpl(DeveloperConsoleCatalogCategoryMeta instance) {
    this.withId(instance.getId()); 
    this.withLabel(instance.getLabel()); 
    this.withTags(instance.getTags()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String id;
  private String label;
  private List<String> tags = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getId() {
    return this.id;
  }
  public A withId(String id) {
    this.id=id; return (A) this;
  }
  public Boolean hasId() {
    return this.id != null;
  }
  public String getLabel() {
    return this.label;
  }
  public A withLabel(String label) {
    this.label=label; return (A) this;
  }
  public Boolean hasLabel() {
    return this.label != null;
  }
  public A addToTags(Integer index,String item) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    this.tags.add(index, item);
    return (A)this;
  }
  public A setToTags(Integer index,String item) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    this.tags.set(index, item); return (A)this;
  }
  public A addToTags(java.lang.String... items) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    for (String item : items) {this.tags.add(item);} return (A)this;
  }
  public A addAllToTags(Collection<String> items) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    for (String item : items) {this.tags.add(item);} return (A)this;
  }
  public A removeFromTags(java.lang.String... items) {
    for (String item : items) {if (this.tags!= null){ this.tags.remove(item);}} return (A)this;
  }
  public A removeAllFromTags(Collection<String> items) {
    for (String item : items) {if (this.tags!= null){ this.tags.remove(item);}} return (A)this;
  }
  public List<String> getTags() {
    return this.tags;
  }
  public String getTag(Integer index) {
    return this.tags.get(index);
  }
  public String getFirstTag() {
    return this.tags.get(0);
  }
  public String getLastTag() {
    return this.tags.get(tags.size() - 1);
  }
  public String getMatchingTag(Predicate<String> predicate) {
    for (String item: tags) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTag(Predicate<String> predicate) {
    for (String item: tags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTags(List<String> tags) {
    if (tags != null) {this.tags = new ArrayList(); for (String item : tags){this.addToTags(item);}} else { this.tags = null;} return (A) this;
  }
  public A withTags(java.lang.String... tags) {
    if (this.tags != null) {this.tags.clear();}
    if (tags != null) {for (String item :tags){ this.addToTags(item);}} return (A) this;
  }
  public Boolean hasTags() {
    return tags != null && !tags.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeveloperConsoleCatalogCategoryMetaFluentImpl that = (DeveloperConsoleCatalogCategoryMetaFluentImpl) o;
    if (id != null ? !id.equals(that.id) :that.id != null) return false;
    if (label != null ? !label.equals(that.label) :that.label != null) return false;
    if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(id,  label,  tags,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (label != null) { sb.append("label:"); sb.append(label + ","); }
    if (tags != null && !tags.isEmpty()) { sb.append("tags:"); sb.append(tags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}