package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClientTLSBuilder extends ClientTLSFluentImpl<ClientTLSBuilder> implements VisitableBuilder<ClientTLS,ClientTLSBuilder>{
  public ClientTLSBuilder() {
    this(false);
  }
  public ClientTLSBuilder(Boolean validationEnabled) {
    this(new ClientTLS(), validationEnabled);
  }
  public ClientTLSBuilder(ClientTLSFluent<?> fluent) {
    this(fluent, false);
  }
  public ClientTLSBuilder(ClientTLSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClientTLS(), validationEnabled);
  }
  public ClientTLSBuilder(ClientTLSFluent<?> fluent,ClientTLS instance) {
    this(fluent, instance, false);
  }
  public ClientTLSBuilder(ClientTLSFluent<?> fluent,ClientTLS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowedSubjectPatterns(instance.getAllowedSubjectPatterns()); 
    fluent.withClientCA(instance.getClientCA()); 
    fluent.withClientCertificatePolicy(instance.getClientCertificatePolicy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClientTLSBuilder(ClientTLS instance) {
    this(instance,false);
  }
  public ClientTLSBuilder(ClientTLS instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowedSubjectPatterns(instance.getAllowedSubjectPatterns()); 
    this.withClientCA(instance.getClientCA()); 
    this.withClientCertificatePolicy(instance.getClientCertificatePolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClientTLSFluent<?> fluent;
  Boolean validationEnabled;
  public ClientTLS build() {
    ClientTLS buildable = new ClientTLS(fluent.getAllowedSubjectPatterns(),fluent.getClientCA(),fluent.getClientCertificatePolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}