package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSISnapshotControllerListBuilder extends CSISnapshotControllerListFluentImpl<CSISnapshotControllerListBuilder> implements VisitableBuilder<CSISnapshotControllerList,CSISnapshotControllerListBuilder>{
  public CSISnapshotControllerListBuilder() {
    this(false);
  }
  public CSISnapshotControllerListBuilder(Boolean validationEnabled) {
    this(new CSISnapshotControllerList(), validationEnabled);
  }
  public CSISnapshotControllerListBuilder(CSISnapshotControllerListFluent<?> fluent) {
    this(fluent, false);
  }
  public CSISnapshotControllerListBuilder(CSISnapshotControllerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSISnapshotControllerList(), validationEnabled);
  }
  public CSISnapshotControllerListBuilder(CSISnapshotControllerListFluent<?> fluent,CSISnapshotControllerList instance) {
    this(fluent, instance, false);
  }
  public CSISnapshotControllerListBuilder(CSISnapshotControllerListFluent<?> fluent,CSISnapshotControllerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CSISnapshotControllerListBuilder(CSISnapshotControllerList instance) {
    this(instance,false);
  }
  public CSISnapshotControllerListBuilder(CSISnapshotControllerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CSISnapshotControllerListFluent<?> fluent;
  Boolean validationEnabled;
  public CSISnapshotControllerList build() {
    CSISnapshotControllerList buildable = new CSISnapshotControllerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}