package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceCatalogControllerManagerSpecFluentImpl<A extends ServiceCatalogControllerManagerSpecFluent<A>> extends BaseFluent<A> implements ServiceCatalogControllerManagerSpecFluent<A>{
  public ServiceCatalogControllerManagerSpecFluentImpl() {
  }
  public ServiceCatalogControllerManagerSpecFluentImpl(ServiceCatalogControllerManagerSpec instance) {
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String logLevel;
  private String managementState;
  private VisitableBuilder<? extends HasMetadata,?> observedConfig;
  private String operatorLogLevel;
  private VisitableBuilder<? extends HasMetadata,?> unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public Boolean hasManagementState() {
    return this.managementState != null;
  }
  
  /**
   * This method has been deprecated, please use method buildObservedConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public HasMetadata buildObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public A withObservedConfig(HasMetadata observedConfig) {
    if (observedConfig instanceof ImagePruner){ this.observedConfig= new ImagePrunerBuilder((ImagePruner)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeControllerManager){ this.observedConfig= new KubeControllerManagerBuilder((KubeControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Storage){ this.observedConfig= new StorageBuilder((Storage)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImageContentSourcePolicy){ this.observedConfig= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCA){ this.observedConfig= new ServiceCABuilder((ServiceCA)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Config){ this.observedConfig= new ConfigBuilder((Config)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PersistentVolumeClaim){ this.observedConfig= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeAPIServer){ this.observedConfig= new KubeAPIServerBuilder((KubeAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressController){ this.observedConfig= new IngressControllerBuilder((IngressController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeStorageVersionMigrator){ this.observedConfig= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Console){ this.observedConfig= new ConsoleBuilder((Console)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClusterCSIDriver){ this.observedConfig= new ClusterCSIDriverBuilder((ClusterCSIDriver)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftControllerManager){ this.observedConfig= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Etcd){ this.observedConfig= new EtcdBuilder((Etcd)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CloudCredential){ this.observedConfig= new CloudCredentialBuilder((CloudCredential)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeScheduler){ this.observedConfig= new KubeSchedulerBuilder((KubeScheduler)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Network){ this.observedConfig= new NetworkBuilder((Network)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogAPIServer){ this.observedConfig= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodNetworkConnectivityCheck){ this.observedConfig= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CSISnapshotController){ this.observedConfig= new CSISnapshotControllerBuilder((CSISnapshotController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogControllerManager){ this.observedConfig= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNS){ this.observedConfig= new DNSBuilder((DNS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSRecord){ this.observedConfig= new DNSRecordBuilder((DNSRecord)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftAPIServer){ this.observedConfig= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Authentication){ this.observedConfig= new AuthenticationBuilder((Authentication)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    return (A) this;
  }
  public Boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imagePrunerObservedConfig!=null){ this.observedConfig= new ImagePrunerBuilder(imagePrunerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ImagePrunerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ImagePrunerObservedConfigNestedImpl(item);
  }
  public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeControllerManagerObservedConfig!=null){ this.observedConfig= new KubeControllerManagerBuilder(kubeControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl(item);
  }
  public A withStorageObservedConfig(Storage storageObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (storageObservedConfig!=null){ this.observedConfig= new StorageBuilder(storageObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.StorageObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfigLike(Storage item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.StorageObservedConfigNestedImpl(item);
  }
  public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imageContentSourcePolicyObservedConfig!=null){ this.observedConfig= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl(item);
  }
  public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCAObservedConfig!=null){ this.observedConfig= new ServiceCABuilder(serviceCAObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCAObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCAObservedConfigNestedImpl(item);
  }
  public A withConfigObservedConfig(Config configObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (configObservedConfig!=null){ this.observedConfig= new ConfigBuilder(configObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ConfigObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfigLike(Config item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ConfigObservedConfigNestedImpl(item);
  }
  public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (persistentVolumeClaimObservedConfig!=null){ this.observedConfig= new PersistentVolumeClaimBuilder(persistentVolumeClaimObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl(item);
  }
  public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeAPIServerObservedConfig!=null){ this.observedConfig= new KubeAPIServerBuilder(kubeAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl(item);
  }
  public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerObservedConfig!=null){ this.observedConfig= new IngressControllerBuilder(ingressControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.IngressControllerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.IngressControllerObservedConfigNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeStorageVersionMigratorObservedConfig!=null){ this.observedConfig= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl(item);
  }
  public A withConsoleObservedConfig(Console consoleObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleObservedConfig!=null){ this.observedConfig= new ConsoleBuilder(consoleObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ConsoleObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ConsoleObservedConfigNestedImpl(item);
  }
  public A withClusterCSIDriverObservedConfig(ClusterCSIDriver clusterCSIDriverObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterCSIDriverObservedConfig!=null){ this.observedConfig= new ClusterCSIDriverBuilder(clusterCSIDriverObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfigLike(ClusterCSIDriver item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl(item);
  }
  public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftControllerManagerObservedConfig!=null){ this.observedConfig= new OpenShiftControllerManagerBuilder(openShiftControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl(item);
  }
  public A withEtcdObservedConfig(Etcd etcdObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (etcdObservedConfig!=null){ this.observedConfig= new EtcdBuilder(etcdObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.EtcdObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.EtcdObservedConfigNestedImpl(item);
  }
  public A withCloudCredentialObservedConfig(CloudCredential cloudCredentialObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cloudCredentialObservedConfig!=null){ this.observedConfig= new CloudCredentialBuilder(cloudCredentialObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.CloudCredentialObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfigLike(CloudCredential item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.CloudCredentialObservedConfigNestedImpl(item);
  }
  public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeSchedulerObservedConfig!=null){ this.observedConfig= new KubeSchedulerBuilder(kubeSchedulerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl(item);
  }
  public A withNetworkObservedConfig(Network networkObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkObservedConfig!=null){ this.observedConfig= new NetworkBuilder(networkObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.NetworkObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.NetworkObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogAPIServerObservedConfig!=null){ this.observedConfig= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckObservedConfig(PodNetworkConnectivityCheck podNetworkConnectivityCheckObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckObservedConfig!=null){ this.observedConfig= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfigLike(PodNetworkConnectivityCheck item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl(item);
  }
  public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cSISnapshotControllerObservedConfig!=null){ this.observedConfig= new CSISnapshotControllerBuilder(cSISnapshotControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogControllerManagerObservedConfig!=null){ this.observedConfig= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl(item);
  }
  public A withDNSObservedConfig(DNS dNSObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSObservedConfig!=null){ this.observedConfig= new DNSBuilder(dNSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.DNSObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.DNSObservedConfigNestedImpl(item);
  }
  public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSRecordObservedConfig!=null){ this.observedConfig= new DNSRecordBuilder(dNSRecordObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.DNSRecordObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.DNSRecordObservedConfigNestedImpl(item);
  }
  public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftAPIServerObservedConfig!=null){ this.observedConfig= new OpenShiftAPIServerBuilder(openShiftAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl(item);
  }
  public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (authenticationObservedConfig!=null){ this.observedConfig= new AuthenticationBuilder(authenticationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.AuthenticationObservedConfigNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.AuthenticationObservedConfigNestedImpl(item);
  }
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel=operatorLogLevel; return (A) this;
  }
  public Boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public HasMetadata buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides instanceof ImagePruner){ this.unsupportedConfigOverrides= new ImagePrunerBuilder((ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManager){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder((KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Storage){ this.unsupportedConfigOverrides= new StorageBuilder((Storage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCA){ this.unsupportedConfigOverrides= new ServiceCABuilder((ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Config){ this.unsupportedConfigOverrides= new ConfigBuilder((Config)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PersistentVolumeClaim){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServer){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder((KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressController){ this.unsupportedConfigOverrides= new IngressControllerBuilder((IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Console){ this.unsupportedConfigOverrides= new ConsoleBuilder((Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriver){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder((ClusterCSIDriver)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManager){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Etcd){ this.unsupportedConfigOverrides= new EtcdBuilder((Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredential){ this.unsupportedConfigOverrides= new CloudCredentialBuilder((CloudCredential)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeScheduler){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder((KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Network){ this.unsupportedConfigOverrides= new NetworkBuilder((Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheck){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotController){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder((CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNS){ this.unsupportedConfigOverrides= new DNSBuilder((DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecord){ this.unsupportedConfigOverrides= new DNSRecordBuilder((DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServer){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Authentication){ this.unsupportedConfigOverrides= new AuthenticationBuilder((Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    return (A) this;
  }
  public Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageUnsupportedConfigOverrides(Storage storageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageBuilder(storageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigUnsupportedConfigOverrides(Config configUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigBuilder(configUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverUnsupportedConfigOverrides(ClusterCSIDriver clusterCSIDriverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder(clusterCSIDriverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCloudCredentialUnsupportedConfigOverrides(CloudCredential cloudCredentialUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialBuilder(cloudCredentialUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckUnsupportedConfigOverrides(PodNetworkConnectivityCheck podNetworkConnectivityCheckUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ServiceCatalogControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl();
  }
  public ServiceCatalogControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
    return new ServiceCatalogControllerManagerSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceCatalogControllerManagerSpecFluentImpl that = (ServiceCatalogControllerManagerSpecFluentImpl) o;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
    if (observedConfig != null ? !observedConfig.equals(that.observedConfig) :that.observedConfig != null) return false;
    if (operatorLogLevel != null ? !operatorLogLevel.equals(that.operatorLogLevel) :that.operatorLogLevel != null) return false;
    if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(logLevel,  managementState,  observedConfig,  operatorLogLevel,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (observedConfig != null) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImagePrunerObservedConfigNestedImpl<N> extends ImagePrunerFluentImpl<ServiceCatalogControllerManagerSpecFluent.ImagePrunerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ImagePrunerObservedConfigNested<N>,Nested<N>{
    ImagePrunerObservedConfigNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerObservedConfigNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImagePrunerObservedConfig() {
      return and();
    }
    
  }
  class KubeControllerManagerObservedConfigNestedImpl<N> extends KubeControllerManagerFluentImpl<ServiceCatalogControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<N>,Nested<N>{
    KubeControllerManagerObservedConfigNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerObservedConfigNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class StorageObservedConfigNestedImpl<N> extends StorageFluentImpl<ServiceCatalogControllerManagerSpecFluent.StorageObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.StorageObservedConfigNested<N>,Nested<N>{
    StorageObservedConfigNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageObservedConfigNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStorageObservedConfig() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyObservedConfigNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<ServiceCatalogControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>,Nested<N>{
    ImageContentSourcePolicyObservedConfigNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyObservedConfigNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImageContentSourcePolicyObservedConfig() {
      return and();
    }
    
  }
  class ServiceCAObservedConfigNestedImpl<N> extends ServiceCAFluentImpl<ServiceCatalogControllerManagerSpecFluent.ServiceCAObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ServiceCAObservedConfigNested<N>,Nested<N>{
    ServiceCAObservedConfigNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAObservedConfigNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCAObservedConfig() {
      return and();
    }
    
  }
  class ConfigObservedConfigNestedImpl<N> extends ConfigFluentImpl<ServiceCatalogControllerManagerSpecFluent.ConfigObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ConfigObservedConfigNested<N>,Nested<N>{
    ConfigObservedConfigNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigObservedConfigNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConfigObservedConfig() {
      return and();
    }
    
  }
  class PersistentVolumeClaimObservedConfigNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ServiceCatalogControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<N>,Nested<N>{
    PersistentVolumeClaimObservedConfigNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimObservedConfigNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPersistentVolumeClaimObservedConfig() {
      return and();
    }
    
  }
  class KubeAPIServerObservedConfigNestedImpl<N> extends KubeAPIServerFluentImpl<ServiceCatalogControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<N>,Nested<N>{
    KubeAPIServerObservedConfigNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerObservedConfigNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeAPIServerObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerObservedConfigNestedImpl<N> extends IngressControllerFluentImpl<ServiceCatalogControllerManagerSpecFluent.IngressControllerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.IngressControllerObservedConfigNested<N>,Nested<N>{
    IngressControllerObservedConfigNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerObservedConfigNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerObservedConfig() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorObservedConfigNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<ServiceCatalogControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>,Nested<N>{
    KubeStorageVersionMigratorObservedConfigNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorObservedConfigNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeStorageVersionMigratorObservedConfig() {
      return and();
    }
    
  }
  class ConsoleObservedConfigNestedImpl<N> extends ConsoleFluentImpl<ServiceCatalogControllerManagerSpecFluent.ConsoleObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ConsoleObservedConfigNested<N>,Nested<N>{
    ConsoleObservedConfigNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleObservedConfigNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleObservedConfig() {
      return and();
    }
    
  }
  class ClusterCSIDriverObservedConfigNestedImpl<N> extends ClusterCSIDriverFluentImpl<ServiceCatalogControllerManagerSpecFluent.ClusterCSIDriverObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ClusterCSIDriverObservedConfigNested<N>,Nested<N>{
    ClusterCSIDriverObservedConfigNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverObservedConfigNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterCSIDriverObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerObservedConfigNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<ServiceCatalogControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>,Nested<N>{
    OpenShiftControllerManagerObservedConfigNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerObservedConfigNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class EtcdObservedConfigNestedImpl<N> extends EtcdFluentImpl<ServiceCatalogControllerManagerSpecFluent.EtcdObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.EtcdObservedConfigNested<N>,Nested<N>{
    EtcdObservedConfigNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdObservedConfigNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEtcdObservedConfig() {
      return and();
    }
    
  }
  class CloudCredentialObservedConfigNestedImpl<N> extends CloudCredentialFluentImpl<ServiceCatalogControllerManagerSpecFluent.CloudCredentialObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.CloudCredentialObservedConfigNested<N>,Nested<N>{
    CloudCredentialObservedConfigNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialObservedConfigNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCloudCredentialObservedConfig() {
      return and();
    }
    
  }
  class KubeSchedulerObservedConfigNestedImpl<N> extends KubeSchedulerFluentImpl<ServiceCatalogControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<N>,Nested<N>{
    KubeSchedulerObservedConfigNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerObservedConfigNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeSchedulerObservedConfig() {
      return and();
    }
    
  }
  class NetworkObservedConfigNestedImpl<N> extends NetworkFluentImpl<ServiceCatalogControllerManagerSpecFluent.NetworkObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.NetworkObservedConfigNested<N>,Nested<N>{
    NetworkObservedConfigNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkObservedConfigNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerObservedConfigNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<ServiceCatalogControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogAPIServerObservedConfigNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogAPIServerObservedConfig() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckObservedConfigNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<ServiceCatalogControllerManagerSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>,Nested<N>{
    PodNetworkConnectivityCheckObservedConfigNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckObservedConfigNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckObservedConfig() {
      return and();
    }
    
  }
  class CSISnapshotControllerObservedConfigNestedImpl<N> extends CSISnapshotControllerFluentImpl<ServiceCatalogControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<N>,Nested<N>{
    CSISnapshotControllerObservedConfigNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerObservedConfigNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCSISnapshotControllerObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerObservedConfigNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<ServiceCatalogControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogControllerManagerObservedConfigNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class DNSObservedConfigNestedImpl<N> extends DNSFluentImpl<ServiceCatalogControllerManagerSpecFluent.DNSObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.DNSObservedConfigNested<N>,Nested<N>{
    DNSObservedConfigNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSObservedConfigNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSObservedConfig() {
      return and();
    }
    
  }
  class DNSRecordObservedConfigNestedImpl<N> extends DNSRecordFluentImpl<ServiceCatalogControllerManagerSpecFluent.DNSRecordObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.DNSRecordObservedConfigNested<N>,Nested<N>{
    DNSRecordObservedConfigNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordObservedConfigNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSRecordObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftAPIServerObservedConfigNestedImpl<N> extends OpenShiftAPIServerFluentImpl<ServiceCatalogControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<N>,Nested<N>{
    OpenShiftAPIServerObservedConfigNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerObservedConfigNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftAPIServerObservedConfig() {
      return and();
    }
    
  }
  class AuthenticationObservedConfigNestedImpl<N> extends AuthenticationFluentImpl<ServiceCatalogControllerManagerSpecFluent.AuthenticationObservedConfigNested<N>> implements ServiceCatalogControllerManagerSpecFluent.AuthenticationObservedConfigNested<N>,Nested<N>{
    AuthenticationObservedConfigNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationObservedConfigNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAuthenticationObservedConfig() {
      return and();
    }
    
  }
  class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerFluentImpl<ServiceCatalogControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerFluentImpl<ServiceCatalogControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageUnsupportedConfigOverridesNestedImpl<N> extends StorageFluentImpl<ServiceCatalogControllerManagerSpecFluent.StorageUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.StorageUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageUnsupportedConfigOverridesNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<ServiceCatalogControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAFluentImpl<ServiceCatalogControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAUnsupportedConfigOverridesNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigUnsupportedConfigOverridesNestedImpl<N> extends ConfigFluentImpl<ServiceCatalogControllerManagerSpecFluent.ConfigUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ConfigUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigUnsupportedConfigOverridesNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ServiceCatalogControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerFluentImpl<ServiceCatalogControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerFluentImpl<ServiceCatalogControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerUnsupportedConfigOverridesNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<ServiceCatalogControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends ConsoleFluentImpl<ServiceCatalogControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleUnsupportedConfigOverridesNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverFluentImpl<ServiceCatalogControllerManagerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<ServiceCatalogControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdUnsupportedConfigOverridesNestedImpl<N> extends EtcdFluentImpl<ServiceCatalogControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdUnsupportedConfigOverridesNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CloudCredentialUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialFluentImpl<ServiceCatalogControllerManagerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerFluentImpl<ServiceCatalogControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkUnsupportedConfigOverridesNestedImpl<N> extends NetworkFluentImpl<ServiceCatalogControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkUnsupportedConfigOverridesNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<ServiceCatalogControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<ServiceCatalogControllerManagerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerFluentImpl<ServiceCatalogControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<ServiceCatalogControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSUnsupportedConfigOverridesNestedImpl<N> extends DNSFluentImpl<ServiceCatalogControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSUnsupportedConfigOverridesNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordFluentImpl<ServiceCatalogControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordUnsupportedConfigOverridesNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerFluentImpl<ServiceCatalogControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationFluentImpl<ServiceCatalogControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements ServiceCatalogControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationUnsupportedConfigOverridesNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) ServiceCatalogControllerManagerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  
}