package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import java.util.Iterator;
import java.lang.Integer;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkSpecFluentImpl<A extends NetworkSpecFluent<A>> extends BaseFluent<A> implements NetworkSpecFluent<A>{
  public NetworkSpecFluentImpl() {
  }
  public NetworkSpecFluentImpl(NetworkSpec instance) {
    this.withAdditionalNetworks(instance.getAdditionalNetworks()); 
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withDefaultNetwork(instance.getDefaultNetwork()); 
    this.withDeployKubeProxy(instance.getDeployKubeProxy()); 
    this.withDisableMultiNetwork(instance.getDisableMultiNetwork()); 
    this.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics()); 
    this.withExportNetworkFlows(instance.getExportNetworkFlows()); 
    this.withKubeProxyConfig(instance.getKubeProxyConfig()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withMigration(instance.getMigration()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<AdditionalNetworkDefinitionBuilder> additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
  private DefaultNetworkDefinitionBuilder defaultNetwork;
  private Boolean deployKubeProxy;
  private Boolean disableMultiNetwork;
  private Boolean disableNetworkDiagnostics;
  private ExportNetworkFlowsBuilder exportNetworkFlows;
  private ProxyConfigBuilder kubeProxyConfig;
  private String logLevel;
  private String managementState;
  private NetworkMigrationBuilder migration;
  private VisitableBuilder<? extends HasMetadata,?> observedConfig;
  private String operatorLogLevel;
  private List<String> serviceNetwork = new ArrayList<String>();
  private VisitableBuilder<? extends HasMetadata,?> unsupportedConfigOverrides;
  private Boolean useMultiNetworkPolicy;
  private Map<String,Object> additionalProperties;
  public A addToAdditionalNetworks(Integer index,AdditionalNetworkDefinition item) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(index >= 0 ? index : _visitables.get("additionalNetworks").size(), builder);this.additionalNetworks.add(index >= 0 ? index : additionalNetworks.size(), builder); return (A)this;
  }
  public A setToAdditionalNetworks(Integer index,AdditionalNetworkDefinition item) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
    if (index < 0 || index >= _visitables.get("additionalNetworks").size()) { _visitables.get("additionalNetworks").add(builder); } else { _visitables.get("additionalNetworks").set(index, builder);}
    if (index < 0 || index >= additionalNetworks.size()) { additionalNetworks.add(builder); } else { additionalNetworks.set(index, builder);}
     return (A)this;
  }
  public A addToAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
  }
  public A addAllToAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
  }
  public A removeFromAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
  }
  public A removeAllFromAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAdditionalNetworks(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    if (additionalNetworks == null) return (A) this;
    final Iterator<AdditionalNetworkDefinitionBuilder> each = additionalNetworks.iterator();
    final List visitables = _visitables.get("additionalNetworks");
    while (each.hasNext()) {
      AdditionalNetworkDefinitionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalNetworks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AdditionalNetworkDefinition> getAdditionalNetworks() {
    return additionalNetworks != null ? build(additionalNetworks) : null;
  }
  public List<AdditionalNetworkDefinition> buildAdditionalNetworks() {
    return additionalNetworks != null ? build(additionalNetworks) : null;
  }
  public AdditionalNetworkDefinition buildAdditionalNetwork(Integer index) {
    return this.additionalNetworks.get(index).build();
  }
  public AdditionalNetworkDefinition buildFirstAdditionalNetwork() {
    return this.additionalNetworks.get(0).build();
  }
  public AdditionalNetworkDefinition buildLastAdditionalNetwork() {
    return this.additionalNetworks.get(additionalNetworks.size() - 1).build();
  }
  public AdditionalNetworkDefinition buildMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    for (AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    for (AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalNetworks(List<AdditionalNetworkDefinition> additionalNetworks) {
    if (this.additionalNetworks != null) { _visitables.get("additionalNetworks").removeAll(this.additionalNetworks);}
    if (additionalNetworks != null) {this.additionalNetworks = new ArrayList(); for (AdditionalNetworkDefinition item : additionalNetworks){this.addToAdditionalNetworks(item);}} else { this.additionalNetworks = null;} return (A) this;
  }
  public A withAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... additionalNetworks) {
    if (this.additionalNetworks != null) {this.additionalNetworks.clear();}
    if (additionalNetworks != null) {for (AdditionalNetworkDefinition item :additionalNetworks){ this.addToAdditionalNetworks(item);}} return (A) this;
  }
  public Boolean hasAdditionalNetworks() {
    return additionalNetworks != null && !additionalNetworks.isEmpty();
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetwork() {
    return new NetworkSpecFluentImpl.AdditionalNetworksNestedImpl();
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetworkLike(AdditionalNetworkDefinition item) {
    return new NetworkSpecFluentImpl.AdditionalNetworksNestedImpl(-1, item);
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> setNewAdditionalNetworkLike(Integer index,AdditionalNetworkDefinition item) {
    return new NetworkSpecFluentImpl.AdditionalNetworksNestedImpl(index, item);
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> editAdditionalNetwork(Integer index) {
    if (additionalNetworks.size() <= index) throw new RuntimeException("Can't edit additionalNetworks. Index exceeds size.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> editFirstAdditionalNetwork() {
    if (additionalNetworks.size() == 0) throw new RuntimeException("Can't edit first additionalNetworks. The list is empty.");
    return setNewAdditionalNetworkLike(0, buildAdditionalNetwork(0));
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> editLastAdditionalNetwork() {
    int index = additionalNetworks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalNetworks. The list is empty.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> editMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalNetworks.size();i++) { 
    if (predicate.test(additionalNetworks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalNetworks. No match found.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  public A addToClusterNetwork(Integer index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(index >= 0 ? index : _visitables.get("clusterNetwork").size(), builder);this.clusterNetwork.add(index >= 0 ? index : clusterNetwork.size(), builder); return (A)this;
  }
  public A setToClusterNetwork(Integer index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterNetwork").size()) { _visitables.get("clusterNetwork").add(builder); } else { _visitables.get("clusterNetwork").set(index, builder);}
    if (index < 0 || index >= clusterNetwork.size()) { clusterNetwork.add(builder); } else { clusterNetwork.set(index, builder);}
     return (A)this;
  }
  public A addToClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public List<ClusterNetworkEntry> buildClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public ClusterNetworkEntry buildClusterNetwork(Integer index) {
    return this.clusterNetwork.get(index).build();
  }
  public ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  public ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").removeAll(this.clusterNetwork);}
    if (clusterNetwork != null) {this.clusterNetwork = new ArrayList(); for (ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
  }
  public A withClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {this.clusterNetwork.clear();}
    if (clusterNetwork != null) {for (ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
  }
  public Boolean hasClusterNetwork() {
    return clusterNetwork != null && !clusterNetwork.isEmpty();
  }
  public A addNewClusterNetwork(String cidr,Integer hostPrefix) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
    return new NetworkSpecFluentImpl.ClusterNetworkNestedImpl();
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
    return new NetworkSpecFluentImpl.ClusterNetworkNestedImpl(-1, item);
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(Integer index,ClusterNetworkEntry item) {
    return new NetworkSpecFluentImpl.ClusterNetworkNestedImpl(index, item);
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(Integer index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public DefaultNetworkDefinition getDefaultNetwork() {
    return this.defaultNetwork!=null ?this.defaultNetwork.build():null;
  }
  public DefaultNetworkDefinition buildDefaultNetwork() {
    return this.defaultNetwork!=null ?this.defaultNetwork.build():null;
  }
  public A withDefaultNetwork(DefaultNetworkDefinition defaultNetwork) {
    _visitables.get("defaultNetwork").remove(this.defaultNetwork);
    if (defaultNetwork!=null){ this.defaultNetwork= new DefaultNetworkDefinitionBuilder(defaultNetwork); _visitables.get("defaultNetwork").add(this.defaultNetwork);} else { this.defaultNetwork = null; _visitables.get("defaultNetwork").remove(this.defaultNetwork); } return (A) this;
  }
  public Boolean hasDefaultNetwork() {
    return this.defaultNetwork != null;
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetwork() {
    return new NetworkSpecFluentImpl.DefaultNetworkNestedImpl();
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetworkLike(DefaultNetworkDefinition item) {
    return new NetworkSpecFluentImpl.DefaultNetworkNestedImpl(item);
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> editDefaultNetwork() {
    return withNewDefaultNetworkLike(getDefaultNetwork());
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetwork() {
    return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): new DefaultNetworkDefinitionBuilder().build());
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetworkLike(DefaultNetworkDefinition item) {
    return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): item);
  }
  public Boolean getDeployKubeProxy() {
    return this.deployKubeProxy;
  }
  public A withDeployKubeProxy(Boolean deployKubeProxy) {
    this.deployKubeProxy=deployKubeProxy; return (A) this;
  }
  public Boolean hasDeployKubeProxy() {
    return this.deployKubeProxy != null;
  }
  public Boolean getDisableMultiNetwork() {
    return this.disableMultiNetwork;
  }
  public A withDisableMultiNetwork(Boolean disableMultiNetwork) {
    this.disableMultiNetwork=disableMultiNetwork; return (A) this;
  }
  public Boolean hasDisableMultiNetwork() {
    return this.disableMultiNetwork != null;
  }
  public Boolean getDisableNetworkDiagnostics() {
    return this.disableNetworkDiagnostics;
  }
  public A withDisableNetworkDiagnostics(Boolean disableNetworkDiagnostics) {
    this.disableNetworkDiagnostics=disableNetworkDiagnostics; return (A) this;
  }
  public Boolean hasDisableNetworkDiagnostics() {
    return this.disableNetworkDiagnostics != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExportNetworkFlows instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExportNetworkFlows getExportNetworkFlows() {
    return this.exportNetworkFlows!=null ?this.exportNetworkFlows.build():null;
  }
  public ExportNetworkFlows buildExportNetworkFlows() {
    return this.exportNetworkFlows!=null ?this.exportNetworkFlows.build():null;
  }
  public A withExportNetworkFlows(ExportNetworkFlows exportNetworkFlows) {
    _visitables.get("exportNetworkFlows").remove(this.exportNetworkFlows);
    if (exportNetworkFlows!=null){ this.exportNetworkFlows= new ExportNetworkFlowsBuilder(exportNetworkFlows); _visitables.get("exportNetworkFlows").add(this.exportNetworkFlows);} else { this.exportNetworkFlows = null; _visitables.get("exportNetworkFlows").remove(this.exportNetworkFlows); } return (A) this;
  }
  public Boolean hasExportNetworkFlows() {
    return this.exportNetworkFlows != null;
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> withNewExportNetworkFlows() {
    return new NetworkSpecFluentImpl.ExportNetworkFlowsNestedImpl();
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> withNewExportNetworkFlowsLike(ExportNetworkFlows item) {
    return new NetworkSpecFluentImpl.ExportNetworkFlowsNestedImpl(item);
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> editExportNetworkFlows() {
    return withNewExportNetworkFlowsLike(getExportNetworkFlows());
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> editOrNewExportNetworkFlows() {
    return withNewExportNetworkFlowsLike(getExportNetworkFlows() != null ? getExportNetworkFlows(): new ExportNetworkFlowsBuilder().build());
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> editOrNewExportNetworkFlowsLike(ExportNetworkFlows item) {
    return withNewExportNetworkFlowsLike(getExportNetworkFlows() != null ? getExportNetworkFlows(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubeProxyConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProxyConfig getKubeProxyConfig() {
    return this.kubeProxyConfig!=null ?this.kubeProxyConfig.build():null;
  }
  public ProxyConfig buildKubeProxyConfig() {
    return this.kubeProxyConfig!=null ?this.kubeProxyConfig.build():null;
  }
  public A withKubeProxyConfig(ProxyConfig kubeProxyConfig) {
    _visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig);
    if (kubeProxyConfig!=null){ this.kubeProxyConfig= new ProxyConfigBuilder(kubeProxyConfig); _visitables.get("kubeProxyConfig").add(this.kubeProxyConfig);} else { this.kubeProxyConfig = null; _visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig); } return (A) this;
  }
  public Boolean hasKubeProxyConfig() {
    return this.kubeProxyConfig != null;
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfig() {
    return new NetworkSpecFluentImpl.KubeProxyConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfigLike(ProxyConfig item) {
    return new NetworkSpecFluentImpl.KubeProxyConfigNestedImpl(item);
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> editKubeProxyConfig() {
    return withNewKubeProxyConfigLike(getKubeProxyConfig());
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfig() {
    return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): new ProxyConfigBuilder().build());
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(ProxyConfig item) {
    return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): item);
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public Boolean hasManagementState() {
    return this.managementState != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMigration instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkMigration getMigration() {
    return this.migration!=null ?this.migration.build():null;
  }
  public NetworkMigration buildMigration() {
    return this.migration!=null ?this.migration.build():null;
  }
  public A withMigration(NetworkMigration migration) {
    _visitables.get("migration").remove(this.migration);
    if (migration!=null){ this.migration= new NetworkMigrationBuilder(migration); _visitables.get("migration").add(this.migration);} else { this.migration = null; _visitables.get("migration").remove(this.migration); } return (A) this;
  }
  public Boolean hasMigration() {
    return this.migration != null;
  }
  public A withNewMigration(String networkType) {
    return (A)withMigration(new NetworkMigration(networkType));
  }
  public NetworkSpecFluent.MigrationNested<A> withNewMigration() {
    return new NetworkSpecFluentImpl.MigrationNestedImpl();
  }
  public NetworkSpecFluent.MigrationNested<A> withNewMigrationLike(NetworkMigration item) {
    return new NetworkSpecFluentImpl.MigrationNestedImpl(item);
  }
  public NetworkSpecFluent.MigrationNested<A> editMigration() {
    return withNewMigrationLike(getMigration());
  }
  public NetworkSpecFluent.MigrationNested<A> editOrNewMigration() {
    return withNewMigrationLike(getMigration() != null ? getMigration(): new NetworkMigrationBuilder().build());
  }
  public NetworkSpecFluent.MigrationNested<A> editOrNewMigrationLike(NetworkMigration item) {
    return withNewMigrationLike(getMigration() != null ? getMigration(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildObservedConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public HasMetadata buildObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public A withObservedConfig(HasMetadata observedConfig) {
    if (observedConfig instanceof ImagePruner){ this.observedConfig= new ImagePrunerBuilder((ImagePruner)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeControllerManager){ this.observedConfig= new KubeControllerManagerBuilder((KubeControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Storage){ this.observedConfig= new StorageBuilder((Storage)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImageContentSourcePolicy){ this.observedConfig= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCA){ this.observedConfig= new ServiceCABuilder((ServiceCA)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Config){ this.observedConfig= new ConfigBuilder((Config)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PersistentVolumeClaim){ this.observedConfig= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeAPIServer){ this.observedConfig= new KubeAPIServerBuilder((KubeAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressController){ this.observedConfig= new IngressControllerBuilder((IngressController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeStorageVersionMigrator){ this.observedConfig= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Console){ this.observedConfig= new ConsoleBuilder((Console)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClusterCSIDriver){ this.observedConfig= new ClusterCSIDriverBuilder((ClusterCSIDriver)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftControllerManager){ this.observedConfig= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Etcd){ this.observedConfig= new EtcdBuilder((Etcd)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CloudCredential){ this.observedConfig= new CloudCredentialBuilder((CloudCredential)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeScheduler){ this.observedConfig= new KubeSchedulerBuilder((KubeScheduler)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Network){ this.observedConfig= new NetworkBuilder((Network)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogAPIServer){ this.observedConfig= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodNetworkConnectivityCheck){ this.observedConfig= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CSISnapshotController){ this.observedConfig= new CSISnapshotControllerBuilder((CSISnapshotController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogControllerManager){ this.observedConfig= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNS){ this.observedConfig= new DNSBuilder((DNS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSRecord){ this.observedConfig= new DNSRecordBuilder((DNSRecord)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftAPIServer){ this.observedConfig= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Authentication){ this.observedConfig= new AuthenticationBuilder((Authentication)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    return (A) this;
  }
  public Boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imagePrunerObservedConfig!=null){ this.observedConfig= new ImagePrunerBuilder(imagePrunerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig() {
    return new NetworkSpecFluentImpl.ImagePrunerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item) {
    return new NetworkSpecFluentImpl.ImagePrunerObservedConfigNestedImpl(item);
  }
  public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeControllerManagerObservedConfig!=null){ this.observedConfig= new KubeControllerManagerBuilder(kubeControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig() {
    return new NetworkSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl(item);
  }
  public A withStorageObservedConfig(Storage storageObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (storageObservedConfig!=null){ this.observedConfig= new StorageBuilder(storageObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfig() {
    return new NetworkSpecFluentImpl.StorageObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfigLike(Storage item) {
    return new NetworkSpecFluentImpl.StorageObservedConfigNestedImpl(item);
  }
  public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imageContentSourcePolicyObservedConfig!=null){ this.observedConfig= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig() {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item) {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl(item);
  }
  public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCAObservedConfig!=null){ this.observedConfig= new ServiceCABuilder(serviceCAObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCAObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item) {
    return new NetworkSpecFluentImpl.ServiceCAObservedConfigNestedImpl(item);
  }
  public A withConfigObservedConfig(Config configObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (configObservedConfig!=null){ this.observedConfig= new ConfigBuilder(configObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfig() {
    return new NetworkSpecFluentImpl.ConfigObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfigLike(Config item) {
    return new NetworkSpecFluentImpl.ConfigObservedConfigNestedImpl(item);
  }
  public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (persistentVolumeClaimObservedConfig!=null){ this.observedConfig= new PersistentVolumeClaimBuilder(persistentVolumeClaimObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig() {
    return new NetworkSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item) {
    return new NetworkSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl(item);
  }
  public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeAPIServerObservedConfig!=null){ this.observedConfig= new KubeAPIServerBuilder(kubeAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig() {
    return new NetworkSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item) {
    return new NetworkSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl(item);
  }
  public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerObservedConfig!=null){ this.observedConfig= new IngressControllerBuilder(ingressControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item) {
    return new NetworkSpecFluentImpl.IngressControllerObservedConfigNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeStorageVersionMigratorObservedConfig!=null){ this.observedConfig= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl(item);
  }
  public A withConsoleObservedConfig(Console consoleObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleObservedConfig!=null){ this.observedConfig= new ConsoleBuilder(consoleObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig() {
    return new NetworkSpecFluentImpl.ConsoleObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item) {
    return new NetworkSpecFluentImpl.ConsoleObservedConfigNestedImpl(item);
  }
  public A withClusterCSIDriverObservedConfig(ClusterCSIDriver clusterCSIDriverObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterCSIDriverObservedConfig!=null){ this.observedConfig= new ClusterCSIDriverBuilder(clusterCSIDriverObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfig() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfigLike(ClusterCSIDriver item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl(item);
  }
  public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftControllerManagerObservedConfig!=null){ this.observedConfig= new OpenShiftControllerManagerBuilder(openShiftControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl(item);
  }
  public A withEtcdObservedConfig(Etcd etcdObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (etcdObservedConfig!=null){ this.observedConfig= new EtcdBuilder(etcdObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig() {
    return new NetworkSpecFluentImpl.EtcdObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item) {
    return new NetworkSpecFluentImpl.EtcdObservedConfigNestedImpl(item);
  }
  public A withCloudCredentialObservedConfig(CloudCredential cloudCredentialObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cloudCredentialObservedConfig!=null){ this.observedConfig= new CloudCredentialBuilder(cloudCredentialObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfig() {
    return new NetworkSpecFluentImpl.CloudCredentialObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfigLike(CloudCredential item) {
    return new NetworkSpecFluentImpl.CloudCredentialObservedConfigNestedImpl(item);
  }
  public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeSchedulerObservedConfig!=null){ this.observedConfig= new KubeSchedulerBuilder(kubeSchedulerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig() {
    return new NetworkSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item) {
    return new NetworkSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl(item);
  }
  public A withNetworkObservedConfig(Network networkObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkObservedConfig!=null){ this.observedConfig= new NetworkBuilder(networkObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig() {
    return new NetworkSpecFluentImpl.NetworkObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item) {
    return new NetworkSpecFluentImpl.NetworkObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogAPIServerObservedConfig!=null){ this.observedConfig= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckObservedConfig(PodNetworkConnectivityCheck podNetworkConnectivityCheckObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckObservedConfig!=null){ this.observedConfig= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfig() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfigLike(PodNetworkConnectivityCheck item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl(item);
  }
  public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cSISnapshotControllerObservedConfig!=null){ this.observedConfig= new CSISnapshotControllerBuilder(cSISnapshotControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogControllerManagerObservedConfig!=null){ this.observedConfig= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl(item);
  }
  public A withDNSObservedConfig(DNS dNSObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSObservedConfig!=null){ this.observedConfig= new DNSBuilder(dNSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig() {
    return new NetworkSpecFluentImpl.DNSObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item) {
    return new NetworkSpecFluentImpl.DNSObservedConfigNestedImpl(item);
  }
  public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSRecordObservedConfig!=null){ this.observedConfig= new DNSRecordBuilder(dNSRecordObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig() {
    return new NetworkSpecFluentImpl.DNSRecordObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item) {
    return new NetworkSpecFluentImpl.DNSRecordObservedConfigNestedImpl(item);
  }
  public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftAPIServerObservedConfig!=null){ this.observedConfig= new OpenShiftAPIServerBuilder(openShiftAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl(item);
  }
  public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (authenticationObservedConfig!=null){ this.observedConfig= new AuthenticationBuilder(authenticationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig() {
    return new NetworkSpecFluentImpl.AuthenticationObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item) {
    return new NetworkSpecFluentImpl.AuthenticationObservedConfigNestedImpl(item);
  }
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel=operatorLogLevel; return (A) this;
  }
  public Boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  public A addToServiceNetwork(Integer index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  public A setToServiceNetwork(Integer index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A addAllToServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A removeFromServiceNetwork(java.lang.String... items) {
    for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public A removeAllFromServiceNetwork(Collection<String> items) {
    for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public List<String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  public String getServiceNetwork(Integer index) {
    return this.serviceNetwork.get(index);
  }
  public String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  public String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  public String getMatchingServiceNetwork(Predicate<String> predicate) {
    for (String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
    for (String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceNetwork(List<String> serviceNetwork) {
    if (serviceNetwork != null) {this.serviceNetwork = new ArrayList(); for (String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
  }
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {this.serviceNetwork.clear();}
    if (serviceNetwork != null) {for (String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
  }
  public Boolean hasServiceNetwork() {
    return serviceNetwork != null && !serviceNetwork.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public HasMetadata buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides instanceof ImagePruner){ this.unsupportedConfigOverrides= new ImagePrunerBuilder((ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManager){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder((KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Storage){ this.unsupportedConfigOverrides= new StorageBuilder((Storage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCA){ this.unsupportedConfigOverrides= new ServiceCABuilder((ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Config){ this.unsupportedConfigOverrides= new ConfigBuilder((Config)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PersistentVolumeClaim){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServer){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder((KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressController){ this.unsupportedConfigOverrides= new IngressControllerBuilder((IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Console){ this.unsupportedConfigOverrides= new ConsoleBuilder((Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriver){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder((ClusterCSIDriver)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManager){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Etcd){ this.unsupportedConfigOverrides= new EtcdBuilder((Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredential){ this.unsupportedConfigOverrides= new CloudCredentialBuilder((CloudCredential)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeScheduler){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder((KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Network){ this.unsupportedConfigOverrides= new NetworkBuilder((Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheck){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotController){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder((CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNS){ this.unsupportedConfigOverrides= new DNSBuilder((DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecord){ this.unsupportedConfigOverrides= new DNSRecordBuilder((DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServer){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Authentication){ this.unsupportedConfigOverrides= new AuthenticationBuilder((Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    return (A) this;
  }
  public Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
    return new NetworkSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageUnsupportedConfigOverrides(Storage storageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageBuilder(storageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item) {
    return new NetworkSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
    return new NetworkSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigUnsupportedConfigOverrides(Config configUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigBuilder(configUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item) {
    return new NetworkSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
    return new NetworkSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
    return new NetworkSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
    return new NetworkSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
    return new NetworkSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverUnsupportedConfigOverrides(ClusterCSIDriver clusterCSIDriverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder(clusterCSIDriverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
    return new NetworkSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCloudCredentialUnsupportedConfigOverrides(CloudCredential cloudCredentialUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialBuilder(cloudCredentialUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item) {
    return new NetworkSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
    return new NetworkSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
    return new NetworkSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckUnsupportedConfigOverrides(PodNetworkConnectivityCheck podNetworkConnectivityCheckUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
    return new NetworkSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
    return new NetworkSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
    return new NetworkSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl(item);
  }
  public Boolean getUseMultiNetworkPolicy() {
    return this.useMultiNetworkPolicy;
  }
  public A withUseMultiNetworkPolicy(Boolean useMultiNetworkPolicy) {
    this.useMultiNetworkPolicy=useMultiNetworkPolicy; return (A) this;
  }
  public Boolean hasUseMultiNetworkPolicy() {
    return this.useMultiNetworkPolicy != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkSpecFluentImpl that = (NetworkSpecFluentImpl) o;
    if (additionalNetworks != null ? !additionalNetworks.equals(that.additionalNetworks) :that.additionalNetworks != null) return false;
    if (clusterNetwork != null ? !clusterNetwork.equals(that.clusterNetwork) :that.clusterNetwork != null) return false;
    if (defaultNetwork != null ? !defaultNetwork.equals(that.defaultNetwork) :that.defaultNetwork != null) return false;
    if (deployKubeProxy != null ? !deployKubeProxy.equals(that.deployKubeProxy) :that.deployKubeProxy != null) return false;
    if (disableMultiNetwork != null ? !disableMultiNetwork.equals(that.disableMultiNetwork) :that.disableMultiNetwork != null) return false;
    if (disableNetworkDiagnostics != null ? !disableNetworkDiagnostics.equals(that.disableNetworkDiagnostics) :that.disableNetworkDiagnostics != null) return false;
    if (exportNetworkFlows != null ? !exportNetworkFlows.equals(that.exportNetworkFlows) :that.exportNetworkFlows != null) return false;
    if (kubeProxyConfig != null ? !kubeProxyConfig.equals(that.kubeProxyConfig) :that.kubeProxyConfig != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
    if (migration != null ? !migration.equals(that.migration) :that.migration != null) return false;
    if (observedConfig != null ? !observedConfig.equals(that.observedConfig) :that.observedConfig != null) return false;
    if (operatorLogLevel != null ? !operatorLogLevel.equals(that.operatorLogLevel) :that.operatorLogLevel != null) return false;
    if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
    if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
    if (useMultiNetworkPolicy != null ? !useMultiNetworkPolicy.equals(that.useMultiNetworkPolicy) :that.useMultiNetworkPolicy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalNetworks,  clusterNetwork,  defaultNetwork,  deployKubeProxy,  disableMultiNetwork,  disableNetworkDiagnostics,  exportNetworkFlows,  kubeProxyConfig,  logLevel,  managementState,  migration,  observedConfig,  operatorLogLevel,  serviceNetwork,  unsupportedConfigOverrides,  useMultiNetworkPolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalNetworks != null && !additionalNetworks.isEmpty()) { sb.append("additionalNetworks:"); sb.append(additionalNetworks + ","); }
    if (clusterNetwork != null && !clusterNetwork.isEmpty()) { sb.append("clusterNetwork:"); sb.append(clusterNetwork + ","); }
    if (defaultNetwork != null) { sb.append("defaultNetwork:"); sb.append(defaultNetwork + ","); }
    if (deployKubeProxy != null) { sb.append("deployKubeProxy:"); sb.append(deployKubeProxy + ","); }
    if (disableMultiNetwork != null) { sb.append("disableMultiNetwork:"); sb.append(disableMultiNetwork + ","); }
    if (disableNetworkDiagnostics != null) { sb.append("disableNetworkDiagnostics:"); sb.append(disableNetworkDiagnostics + ","); }
    if (exportNetworkFlows != null) { sb.append("exportNetworkFlows:"); sb.append(exportNetworkFlows + ","); }
    if (kubeProxyConfig != null) { sb.append("kubeProxyConfig:"); sb.append(kubeProxyConfig + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (migration != null) { sb.append("migration:"); sb.append(migration + ","); }
    if (observedConfig != null) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (serviceNetwork != null && !serviceNetwork.isEmpty()) { sb.append("serviceNetwork:"); sb.append(serviceNetwork + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (useMultiNetworkPolicy != null) { sb.append("useMultiNetworkPolicy:"); sb.append(useMultiNetworkPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withDeployKubeProxy() {
    return withDeployKubeProxy(true);
  }
  public A withDisableMultiNetwork() {
    return withDisableMultiNetwork(true);
  }
  public A withDisableNetworkDiagnostics() {
    return withDisableNetworkDiagnostics(true);
  }
  public A withUseMultiNetworkPolicy() {
    return withUseMultiNetworkPolicy(true);
  }
  class AdditionalNetworksNestedImpl<N> extends AdditionalNetworkDefinitionFluentImpl<NetworkSpecFluent.AdditionalNetworksNested<N>> implements NetworkSpecFluent.AdditionalNetworksNested<N>,Nested<N>{
    AdditionalNetworksNestedImpl(Integer index,AdditionalNetworkDefinition item) {
      this.index = index;
      this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworksNestedImpl() {
      this.index = -1;
      this.builder = new AdditionalNetworkDefinitionBuilder(this);
    }
    AdditionalNetworkDefinitionBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.setToAdditionalNetworks(index,builder.build());
    }
    public N endAdditionalNetwork() {
      return and();
    }
    
  }
  class ClusterNetworkNestedImpl<N> extends ClusterNetworkEntryFluentImpl<NetworkSpecFluent.ClusterNetworkNested<N>> implements NetworkSpecFluent.ClusterNetworkNested<N>,Nested<N>{
    ClusterNetworkNestedImpl(Integer index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkNestedImpl() {
      this.index = -1;
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.setToClusterNetwork(index,builder.build());
    }
    public N endClusterNetwork() {
      return and();
    }
    
  }
  class DefaultNetworkNestedImpl<N> extends DefaultNetworkDefinitionFluentImpl<NetworkSpecFluent.DefaultNetworkNested<N>> implements NetworkSpecFluent.DefaultNetworkNested<N>,Nested<N>{
    DefaultNetworkNestedImpl(DefaultNetworkDefinition item) {
      this.builder = new DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkNestedImpl() {
      this.builder = new DefaultNetworkDefinitionBuilder(this);
    }
    DefaultNetworkDefinitionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withDefaultNetwork(builder.build());
    }
    public N endDefaultNetwork() {
      return and();
    }
    
  }
  class ExportNetworkFlowsNestedImpl<N> extends ExportNetworkFlowsFluentImpl<NetworkSpecFluent.ExportNetworkFlowsNested<N>> implements NetworkSpecFluent.ExportNetworkFlowsNested<N>,Nested<N>{
    ExportNetworkFlowsNestedImpl(ExportNetworkFlows item) {
      this.builder = new ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsNestedImpl() {
      this.builder = new ExportNetworkFlowsBuilder(this);
    }
    ExportNetworkFlowsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withExportNetworkFlows(builder.build());
    }
    public N endExportNetworkFlows() {
      return and();
    }
    
  }
  class KubeProxyConfigNestedImpl<N> extends ProxyConfigFluentImpl<NetworkSpecFluent.KubeProxyConfigNested<N>> implements NetworkSpecFluent.KubeProxyConfigNested<N>,Nested<N>{
    KubeProxyConfigNestedImpl(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    KubeProxyConfigNestedImpl() {
      this.builder = new ProxyConfigBuilder(this);
    }
    ProxyConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withKubeProxyConfig(builder.build());
    }
    public N endKubeProxyConfig() {
      return and();
    }
    
  }
  class MigrationNestedImpl<N> extends NetworkMigrationFluentImpl<NetworkSpecFluent.MigrationNested<N>> implements NetworkSpecFluent.MigrationNested<N>,Nested<N>{
    MigrationNestedImpl(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    MigrationNestedImpl() {
      this.builder = new NetworkMigrationBuilder(this);
    }
    NetworkMigrationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withMigration(builder.build());
    }
    public N endMigration() {
      return and();
    }
    
  }
  class ImagePrunerObservedConfigNestedImpl<N> extends ImagePrunerFluentImpl<NetworkSpecFluent.ImagePrunerObservedConfigNested<N>> implements NetworkSpecFluent.ImagePrunerObservedConfigNested<N>,Nested<N>{
    ImagePrunerObservedConfigNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerObservedConfigNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImagePrunerObservedConfig() {
      return and();
    }
    
  }
  class KubeControllerManagerObservedConfigNestedImpl<N> extends KubeControllerManagerFluentImpl<NetworkSpecFluent.KubeControllerManagerObservedConfigNested<N>> implements NetworkSpecFluent.KubeControllerManagerObservedConfigNested<N>,Nested<N>{
    KubeControllerManagerObservedConfigNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerObservedConfigNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class StorageObservedConfigNestedImpl<N> extends StorageFluentImpl<NetworkSpecFluent.StorageObservedConfigNested<N>> implements NetworkSpecFluent.StorageObservedConfigNested<N>,Nested<N>{
    StorageObservedConfigNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageObservedConfigNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStorageObservedConfig() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyObservedConfigNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> implements NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>,Nested<N>{
    ImageContentSourcePolicyObservedConfigNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyObservedConfigNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImageContentSourcePolicyObservedConfig() {
      return and();
    }
    
  }
  class ServiceCAObservedConfigNestedImpl<N> extends ServiceCAFluentImpl<NetworkSpecFluent.ServiceCAObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCAObservedConfigNested<N>,Nested<N>{
    ServiceCAObservedConfigNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAObservedConfigNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCAObservedConfig() {
      return and();
    }
    
  }
  class ConfigObservedConfigNestedImpl<N> extends ConfigFluentImpl<NetworkSpecFluent.ConfigObservedConfigNested<N>> implements NetworkSpecFluent.ConfigObservedConfigNested<N>,Nested<N>{
    ConfigObservedConfigNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigObservedConfigNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConfigObservedConfig() {
      return and();
    }
    
  }
  class PersistentVolumeClaimObservedConfigNestedImpl<N> extends PersistentVolumeClaimFluentImpl<NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> implements NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<N>,Nested<N>{
    PersistentVolumeClaimObservedConfigNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimObservedConfigNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPersistentVolumeClaimObservedConfig() {
      return and();
    }
    
  }
  class KubeAPIServerObservedConfigNestedImpl<N> extends KubeAPIServerFluentImpl<NetworkSpecFluent.KubeAPIServerObservedConfigNested<N>> implements NetworkSpecFluent.KubeAPIServerObservedConfigNested<N>,Nested<N>{
    KubeAPIServerObservedConfigNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerObservedConfigNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeAPIServerObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerObservedConfigNestedImpl<N> extends IngressControllerFluentImpl<NetworkSpecFluent.IngressControllerObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerObservedConfigNested<N>,Nested<N>{
    IngressControllerObservedConfigNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerObservedConfigNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerObservedConfig() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorObservedConfigNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>,Nested<N>{
    KubeStorageVersionMigratorObservedConfigNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorObservedConfigNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeStorageVersionMigratorObservedConfig() {
      return and();
    }
    
  }
  class ConsoleObservedConfigNestedImpl<N> extends ConsoleFluentImpl<NetworkSpecFluent.ConsoleObservedConfigNested<N>> implements NetworkSpecFluent.ConsoleObservedConfigNested<N>,Nested<N>{
    ConsoleObservedConfigNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleObservedConfigNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleObservedConfig() {
      return and();
    }
    
  }
  class ClusterCSIDriverObservedConfigNestedImpl<N> extends ClusterCSIDriverFluentImpl<NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<N>> implements NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<N>,Nested<N>{
    ClusterCSIDriverObservedConfigNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverObservedConfigNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterCSIDriverObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerObservedConfigNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>,Nested<N>{
    OpenShiftControllerManagerObservedConfigNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerObservedConfigNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class EtcdObservedConfigNestedImpl<N> extends EtcdFluentImpl<NetworkSpecFluent.EtcdObservedConfigNested<N>> implements NetworkSpecFluent.EtcdObservedConfigNested<N>,Nested<N>{
    EtcdObservedConfigNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdObservedConfigNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEtcdObservedConfig() {
      return and();
    }
    
  }
  class CloudCredentialObservedConfigNestedImpl<N> extends CloudCredentialFluentImpl<NetworkSpecFluent.CloudCredentialObservedConfigNested<N>> implements NetworkSpecFluent.CloudCredentialObservedConfigNested<N>,Nested<N>{
    CloudCredentialObservedConfigNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialObservedConfigNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCloudCredentialObservedConfig() {
      return and();
    }
    
  }
  class KubeSchedulerObservedConfigNestedImpl<N> extends KubeSchedulerFluentImpl<NetworkSpecFluent.KubeSchedulerObservedConfigNested<N>> implements NetworkSpecFluent.KubeSchedulerObservedConfigNested<N>,Nested<N>{
    KubeSchedulerObservedConfigNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerObservedConfigNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeSchedulerObservedConfig() {
      return and();
    }
    
  }
  class NetworkObservedConfigNestedImpl<N> extends NetworkFluentImpl<NetworkSpecFluent.NetworkObservedConfigNested<N>> implements NetworkSpecFluent.NetworkObservedConfigNested<N>,Nested<N>{
    NetworkObservedConfigNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkObservedConfigNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerObservedConfigNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogAPIServerObservedConfigNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogAPIServerObservedConfig() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckObservedConfigNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>,Nested<N>{
    PodNetworkConnectivityCheckObservedConfigNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckObservedConfigNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckObservedConfig() {
      return and();
    }
    
  }
  class CSISnapshotControllerObservedConfigNestedImpl<N> extends CSISnapshotControllerFluentImpl<NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<N>> implements NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<N>,Nested<N>{
    CSISnapshotControllerObservedConfigNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerObservedConfigNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCSISnapshotControllerObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerObservedConfigNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogControllerManagerObservedConfigNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class DNSObservedConfigNestedImpl<N> extends DNSFluentImpl<NetworkSpecFluent.DNSObservedConfigNested<N>> implements NetworkSpecFluent.DNSObservedConfigNested<N>,Nested<N>{
    DNSObservedConfigNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSObservedConfigNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSObservedConfig() {
      return and();
    }
    
  }
  class DNSRecordObservedConfigNestedImpl<N> extends DNSRecordFluentImpl<NetworkSpecFluent.DNSRecordObservedConfigNested<N>> implements NetworkSpecFluent.DNSRecordObservedConfigNested<N>,Nested<N>{
    DNSRecordObservedConfigNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordObservedConfigNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSRecordObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftAPIServerObservedConfigNestedImpl<N> extends OpenShiftAPIServerFluentImpl<NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<N>,Nested<N>{
    OpenShiftAPIServerObservedConfigNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerObservedConfigNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftAPIServerObservedConfig() {
      return and();
    }
    
  }
  class AuthenticationObservedConfigNestedImpl<N> extends AuthenticationFluentImpl<NetworkSpecFluent.AuthenticationObservedConfigNested<N>> implements NetworkSpecFluent.AuthenticationObservedConfigNested<N>,Nested<N>{
    AuthenticationObservedConfigNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationObservedConfigNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAuthenticationObservedConfig() {
      return and();
    }
    
  }
  class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerFluentImpl<NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerFluentImpl<NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageUnsupportedConfigOverridesNestedImpl<N> extends StorageFluentImpl<NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageUnsupportedConfigOverridesNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAFluentImpl<NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAUnsupportedConfigOverridesNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigUnsupportedConfigOverridesNestedImpl<N> extends ConfigFluentImpl<NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigUnsupportedConfigOverridesNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerFluentImpl<NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerFluentImpl<NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerUnsupportedConfigOverridesNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends ConsoleFluentImpl<NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleUnsupportedConfigOverridesNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverFluentImpl<NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdUnsupportedConfigOverridesNestedImpl<N> extends EtcdFluentImpl<NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdUnsupportedConfigOverridesNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CloudCredentialUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialFluentImpl<NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerFluentImpl<NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkUnsupportedConfigOverridesNestedImpl<N> extends NetworkFluentImpl<NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkUnsupportedConfigOverridesNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerFluentImpl<NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSUnsupportedConfigOverridesNestedImpl<N> extends DNSFluentImpl<NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSUnsupportedConfigOverridesNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordFluentImpl<NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordUnsupportedConfigOverridesNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerFluentImpl<NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationFluentImpl<NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationUnsupportedConfigOverridesNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  
}