package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import java.lang.Integer;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

 /**
  * Generated
  */
public interface NetworkSpecFluent<A extends NetworkSpecFluent<A>> extends Fluent<A>{
  public A addToAdditionalNetworks(Integer index,AdditionalNetworkDefinition item);
  public A setToAdditionalNetworks(Integer index,AdditionalNetworkDefinition item);
  public A addToAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items);
  public A addAllToAdditionalNetworks(Collection<AdditionalNetworkDefinition> items);
  public A removeFromAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items);
  public A removeAllFromAdditionalNetworks(Collection<AdditionalNetworkDefinition> items);
  public A removeMatchingFromAdditionalNetworks(Predicate<AdditionalNetworkDefinitionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildAdditionalNetworks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AdditionalNetworkDefinition> getAdditionalNetworks();
  public List<AdditionalNetworkDefinition> buildAdditionalNetworks();
  public AdditionalNetworkDefinition buildAdditionalNetwork(Integer index);
  public AdditionalNetworkDefinition buildFirstAdditionalNetwork();
  public AdditionalNetworkDefinition buildLastAdditionalNetwork();
  public AdditionalNetworkDefinition buildMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate);
  public Boolean hasMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate);
  public A withAdditionalNetworks(List<AdditionalNetworkDefinition> additionalNetworks);
  public A withAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... additionalNetworks);
  public Boolean hasAdditionalNetworks();
  public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetwork();
  public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetworkLike(AdditionalNetworkDefinition item);
  public NetworkSpecFluent.AdditionalNetworksNested<A> setNewAdditionalNetworkLike(Integer index,AdditionalNetworkDefinition item);
  public NetworkSpecFluent.AdditionalNetworksNested<A> editAdditionalNetwork(Integer index);
  public NetworkSpecFluent.AdditionalNetworksNested<A> editFirstAdditionalNetwork();
  public NetworkSpecFluent.AdditionalNetworksNested<A> editLastAdditionalNetwork();
  public NetworkSpecFluent.AdditionalNetworksNested<A> editMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate);
  public A addToClusterNetwork(Integer index,ClusterNetworkEntry item);
  public A setToClusterNetwork(Integer index,ClusterNetworkEntry item);
  public A addToClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items);
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items);
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items);
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items);
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getClusterNetwork();
  public List<ClusterNetworkEntry> buildClusterNetwork();
  public ClusterNetworkEntry buildClusterNetwork(Integer index);
  public ClusterNetworkEntry buildFirstClusterNetwork();
  public ClusterNetworkEntry buildLastClusterNetwork();
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork);
  public A withClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... clusterNetwork);
  public Boolean hasClusterNetwork();
  public A addNewClusterNetwork(String cidr,Integer hostPrefix);
  public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork();
  public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item);
  public NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(Integer index,ClusterNetworkEntry item);
  public NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(Integer index);
  public NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork();
  public NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork();
  public NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDefaultNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public DefaultNetworkDefinition getDefaultNetwork();
  public DefaultNetworkDefinition buildDefaultNetwork();
  public A withDefaultNetwork(DefaultNetworkDefinition defaultNetwork);
  public Boolean hasDefaultNetwork();
  public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetwork();
  public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetworkLike(DefaultNetworkDefinition item);
  public NetworkSpecFluent.DefaultNetworkNested<A> editDefaultNetwork();
  public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetwork();
  public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetworkLike(DefaultNetworkDefinition item);
  public Boolean getDeployKubeProxy();
  public A withDeployKubeProxy(Boolean deployKubeProxy);
  public Boolean hasDeployKubeProxy();
  public Boolean getDisableMultiNetwork();
  public A withDisableMultiNetwork(Boolean disableMultiNetwork);
  public Boolean hasDisableMultiNetwork();
  public Boolean getDisableNetworkDiagnostics();
  public A withDisableNetworkDiagnostics(Boolean disableNetworkDiagnostics);
  public Boolean hasDisableNetworkDiagnostics();
  
  /**
   * This method has been deprecated, please use method buildExportNetworkFlows instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExportNetworkFlows getExportNetworkFlows();
  public ExportNetworkFlows buildExportNetworkFlows();
  public A withExportNetworkFlows(ExportNetworkFlows exportNetworkFlows);
  public Boolean hasExportNetworkFlows();
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> withNewExportNetworkFlows();
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> withNewExportNetworkFlowsLike(ExportNetworkFlows item);
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> editExportNetworkFlows();
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> editOrNewExportNetworkFlows();
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> editOrNewExportNetworkFlowsLike(ExportNetworkFlows item);
  
  /**
   * This method has been deprecated, please use method buildKubeProxyConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProxyConfig getKubeProxyConfig();
  public ProxyConfig buildKubeProxyConfig();
  public A withKubeProxyConfig(ProxyConfig kubeProxyConfig);
  public Boolean hasKubeProxyConfig();
  public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfig();
  public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfigLike(ProxyConfig item);
  public NetworkSpecFluent.KubeProxyConfigNested<A> editKubeProxyConfig();
  public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfig();
  public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(ProxyConfig item);
  public String getLogLevel();
  public A withLogLevel(String logLevel);
  public Boolean hasLogLevel();
  public String getManagementState();
  public A withManagementState(String managementState);
  public Boolean hasManagementState();
  
  /**
   * This method has been deprecated, please use method buildMigration instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkMigration getMigration();
  public NetworkMigration buildMigration();
  public A withMigration(NetworkMigration migration);
  public Boolean hasMigration();
  public A withNewMigration(String networkType);
  public NetworkSpecFluent.MigrationNested<A> withNewMigration();
  public NetworkSpecFluent.MigrationNested<A> withNewMigrationLike(NetworkMigration item);
  public NetworkSpecFluent.MigrationNested<A> editMigration();
  public NetworkSpecFluent.MigrationNested<A> editOrNewMigration();
  public NetworkSpecFluent.MigrationNested<A> editOrNewMigrationLike(NetworkMigration item);
  
  /**
   * This method has been deprecated, please use method buildObservedConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getObservedConfig();
  public HasMetadata buildObservedConfig();
  public A withObservedConfig(HasMetadata observedConfig);
  public Boolean hasObservedConfig();
  public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig);
  public NetworkSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig();
  public NetworkSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item);
  public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig);
  public NetworkSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig();
  public NetworkSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item);
  public A withStorageObservedConfig(Storage storageObservedConfig);
  public NetworkSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfig();
  public NetworkSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfigLike(Storage item);
  public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig);
  public NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig();
  public NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item);
  public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig);
  public NetworkSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig();
  public NetworkSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item);
  public A withConfigObservedConfig(Config configObservedConfig);
  public NetworkSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfig();
  public NetworkSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfigLike(Config item);
  public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig);
  public NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig();
  public NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item);
  public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig);
  public NetworkSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig();
  public NetworkSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item);
  public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig);
  public NetworkSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig();
  public NetworkSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item);
  public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig);
  public NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig();
  public NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item);
  public A withConsoleObservedConfig(Console consoleObservedConfig);
  public NetworkSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig();
  public NetworkSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item);
  public A withClusterCSIDriverObservedConfig(ClusterCSIDriver clusterCSIDriverObservedConfig);
  public NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfig();
  public NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfigLike(ClusterCSIDriver item);
  public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig);
  public NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig();
  public NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item);
  public A withEtcdObservedConfig(Etcd etcdObservedConfig);
  public NetworkSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig();
  public NetworkSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item);
  public A withCloudCredentialObservedConfig(CloudCredential cloudCredentialObservedConfig);
  public NetworkSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfig();
  public NetworkSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfigLike(CloudCredential item);
  public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig);
  public NetworkSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig();
  public NetworkSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item);
  public A withNetworkObservedConfig(Network networkObservedConfig);
  public NetworkSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig();
  public NetworkSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item);
  public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig);
  public NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig();
  public NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item);
  public A withPodNetworkConnectivityCheckObservedConfig(PodNetworkConnectivityCheck podNetworkConnectivityCheckObservedConfig);
  public NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfig();
  public NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfigLike(PodNetworkConnectivityCheck item);
  public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig);
  public NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig();
  public NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item);
  public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig);
  public NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig();
  public NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item);
  public A withDNSObservedConfig(DNS dNSObservedConfig);
  public NetworkSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig();
  public NetworkSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item);
  public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig);
  public NetworkSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig();
  public NetworkSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item);
  public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig);
  public NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig();
  public NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item);
  public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig);
  public NetworkSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig();
  public NetworkSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item);
  public String getOperatorLogLevel();
  public A withOperatorLogLevel(String operatorLogLevel);
  public Boolean hasOperatorLogLevel();
  public A addToServiceNetwork(Integer index,String item);
  public A setToServiceNetwork(Integer index,String item);
  public A addToServiceNetwork(java.lang.String... items);
  public A addAllToServiceNetwork(Collection<String> items);
  public A removeFromServiceNetwork(java.lang.String... items);
  public A removeAllFromServiceNetwork(Collection<String> items);
  public List<String> getServiceNetwork();
  public String getServiceNetwork(Integer index);
  public String getFirstServiceNetwork();
  public String getLastServiceNetwork();
  public String getMatchingServiceNetwork(Predicate<String> predicate);
  public Boolean hasMatchingServiceNetwork(Predicate<String> predicate);
  public A withServiceNetwork(List<String> serviceNetwork);
  public A withServiceNetwork(java.lang.String... serviceNetwork);
  public Boolean hasServiceNetwork();
  
  /**
   * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getUnsupportedConfigOverrides();
  public HasMetadata buildUnsupportedConfigOverrides();
  public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides);
  public Boolean hasUnsupportedConfigOverrides();
  public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides);
  public NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides();
  public NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item);
  public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides);
  public NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides();
  public NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item);
  public A withStorageUnsupportedConfigOverrides(Storage storageUnsupportedConfigOverrides);
  public NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides();
  public NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item);
  public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides);
  public NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides();
  public NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item);
  public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides);
  public NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides();
  public NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item);
  public A withConfigUnsupportedConfigOverrides(Config configUnsupportedConfigOverrides);
  public NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides();
  public NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item);
  public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides);
  public NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides();
  public NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item);
  public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides);
  public NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides();
  public NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item);
  public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides);
  public NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides();
  public NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item);
  public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides);
  public NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides();
  public NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item);
  public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides);
  public NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides();
  public NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item);
  public A withClusterCSIDriverUnsupportedConfigOverrides(ClusterCSIDriver clusterCSIDriverUnsupportedConfigOverrides);
  public NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides();
  public NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item);
  public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides);
  public NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides();
  public NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item);
  public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides);
  public NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides();
  public NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item);
  public A withCloudCredentialUnsupportedConfigOverrides(CloudCredential cloudCredentialUnsupportedConfigOverrides);
  public NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides();
  public NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item);
  public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides);
  public NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides();
  public NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item);
  public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides);
  public NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides();
  public NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item);
  public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides);
  public NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides();
  public NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item);
  public A withPodNetworkConnectivityCheckUnsupportedConfigOverrides(PodNetworkConnectivityCheck podNetworkConnectivityCheckUnsupportedConfigOverrides);
  public NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides();
  public NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item);
  public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides);
  public NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides();
  public NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item);
  public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides);
  public NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides();
  public NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item);
  public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides);
  public NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides();
  public NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item);
  public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides);
  public NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides();
  public NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item);
  public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides);
  public NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides();
  public NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item);
  public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides);
  public NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides();
  public NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item);
  public Boolean getUseMultiNetworkPolicy();
  public A withUseMultiNetworkPolicy(Boolean useMultiNetworkPolicy);
  public Boolean hasUseMultiNetworkPolicy();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withDeployKubeProxy();
  public A withDisableMultiNetwork();
  public A withDisableNetworkDiagnostics();
  public A withUseMultiNetworkPolicy();
  public interface AdditionalNetworksNested<N> extends Nested<N>,AdditionalNetworkDefinitionFluent<NetworkSpecFluent.AdditionalNetworksNested<N>>{
    public N and();
    public N endAdditionalNetwork();
    
  }
  public interface ClusterNetworkNested<N> extends Nested<N>,ClusterNetworkEntryFluent<NetworkSpecFluent.ClusterNetworkNested<N>>{
    public N and();
    public N endClusterNetwork();
    
  }
  public interface DefaultNetworkNested<N> extends Nested<N>,DefaultNetworkDefinitionFluent<NetworkSpecFluent.DefaultNetworkNested<N>>{
    public N and();
    public N endDefaultNetwork();
    
  }
  public interface ExportNetworkFlowsNested<N> extends Nested<N>,ExportNetworkFlowsFluent<NetworkSpecFluent.ExportNetworkFlowsNested<N>>{
    public N and();
    public N endExportNetworkFlows();
    
  }
  public interface KubeProxyConfigNested<N> extends Nested<N>,ProxyConfigFluent<NetworkSpecFluent.KubeProxyConfigNested<N>>{
    public N and();
    public N endKubeProxyConfig();
    
  }
  public interface MigrationNested<N> extends Nested<N>,NetworkMigrationFluent<NetworkSpecFluent.MigrationNested<N>>{
    public N and();
    public N endMigration();
    
  }
  public interface ImagePrunerObservedConfigNested<N> extends Nested<N>,ImagePrunerFluent<NetworkSpecFluent.ImagePrunerObservedConfigNested<N>>{
    public N and();
    public N endImagePrunerObservedConfig();
    
  }
  public interface KubeControllerManagerObservedConfigNested<N> extends Nested<N>,KubeControllerManagerFluent<NetworkSpecFluent.KubeControllerManagerObservedConfigNested<N>>{
    public N and();
    public N endKubeControllerManagerObservedConfig();
    
  }
  public interface StorageObservedConfigNested<N> extends Nested<N>,StorageFluent<NetworkSpecFluent.StorageObservedConfigNested<N>>{
    public N and();
    public N endStorageObservedConfig();
    
  }
  public interface ImageContentSourcePolicyObservedConfigNested<N> extends Nested<N>,ImageContentSourcePolicyFluent<NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>>{
    public N and();
    public N endImageContentSourcePolicyObservedConfig();
    
  }
  public interface ServiceCAObservedConfigNested<N> extends Nested<N>,ServiceCAFluent<NetworkSpecFluent.ServiceCAObservedConfigNested<N>>{
    public N and();
    public N endServiceCAObservedConfig();
    
  }
  public interface ConfigObservedConfigNested<N> extends Nested<N>,ConfigFluent<NetworkSpecFluent.ConfigObservedConfigNested<N>>{
    public N and();
    public N endConfigObservedConfig();
    
  }
  public interface PersistentVolumeClaimObservedConfigNested<N> extends Nested<N>,PersistentVolumeClaimFluent<NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<N>>{
    public N and();
    public N endPersistentVolumeClaimObservedConfig();
    
  }
  public interface KubeAPIServerObservedConfigNested<N> extends Nested<N>,KubeAPIServerFluent<NetworkSpecFluent.KubeAPIServerObservedConfigNested<N>>{
    public N and();
    public N endKubeAPIServerObservedConfig();
    
  }
  public interface IngressControllerObservedConfigNested<N> extends Nested<N>,IngressControllerFluent<NetworkSpecFluent.IngressControllerObservedConfigNested<N>>{
    public N and();
    public N endIngressControllerObservedConfig();
    
  }
  public interface KubeStorageVersionMigratorObservedConfigNested<N> extends Nested<N>,KubeStorageVersionMigratorFluent<NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>>{
    public N and();
    public N endKubeStorageVersionMigratorObservedConfig();
    
  }
  public interface ConsoleObservedConfigNested<N> extends Nested<N>,ConsoleFluent<NetworkSpecFluent.ConsoleObservedConfigNested<N>>{
    public N and();
    public N endConsoleObservedConfig();
    
  }
  public interface ClusterCSIDriverObservedConfigNested<N> extends Nested<N>,ClusterCSIDriverFluent<NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<N>>{
    public N and();
    public N endClusterCSIDriverObservedConfig();
    
  }
  public interface OpenShiftControllerManagerObservedConfigNested<N> extends Nested<N>,OpenShiftControllerManagerFluent<NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>>{
    public N and();
    public N endOpenShiftControllerManagerObservedConfig();
    
  }
  public interface EtcdObservedConfigNested<N> extends Nested<N>,EtcdFluent<NetworkSpecFluent.EtcdObservedConfigNested<N>>{
    public N and();
    public N endEtcdObservedConfig();
    
  }
  public interface CloudCredentialObservedConfigNested<N> extends Nested<N>,CloudCredentialFluent<NetworkSpecFluent.CloudCredentialObservedConfigNested<N>>{
    public N and();
    public N endCloudCredentialObservedConfig();
    
  }
  public interface KubeSchedulerObservedConfigNested<N> extends Nested<N>,KubeSchedulerFluent<NetworkSpecFluent.KubeSchedulerObservedConfigNested<N>>{
    public N and();
    public N endKubeSchedulerObservedConfig();
    
  }
  public interface NetworkObservedConfigNested<N> extends Nested<N>,NetworkFluent<NetworkSpecFluent.NetworkObservedConfigNested<N>>{
    public N and();
    public N endNetworkObservedConfig();
    
  }
  public interface ServiceCatalogAPIServerObservedConfigNested<N> extends Nested<N>,ServiceCatalogAPIServerFluent<NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>>{
    public N and();
    public N endServiceCatalogAPIServerObservedConfig();
    
  }
  public interface PodNetworkConnectivityCheckObservedConfigNested<N> extends Nested<N>,PodNetworkConnectivityCheckFluent<NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>>{
    public N and();
    public N endPodNetworkConnectivityCheckObservedConfig();
    
  }
  public interface CSISnapshotControllerObservedConfigNested<N> extends Nested<N>,CSISnapshotControllerFluent<NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<N>>{
    public N and();
    public N endCSISnapshotControllerObservedConfig();
    
  }
  public interface ServiceCatalogControllerManagerObservedConfigNested<N> extends Nested<N>,ServiceCatalogControllerManagerFluent<NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>>{
    public N and();
    public N endServiceCatalogControllerManagerObservedConfig();
    
  }
  public interface DNSObservedConfigNested<N> extends Nested<N>,DNSFluent<NetworkSpecFluent.DNSObservedConfigNested<N>>{
    public N and();
    public N endDNSObservedConfig();
    
  }
  public interface DNSRecordObservedConfigNested<N> extends Nested<N>,DNSRecordFluent<NetworkSpecFluent.DNSRecordObservedConfigNested<N>>{
    public N and();
    public N endDNSRecordObservedConfig();
    
  }
  public interface OpenShiftAPIServerObservedConfigNested<N> extends Nested<N>,OpenShiftAPIServerFluent<NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<N>>{
    public N and();
    public N endOpenShiftAPIServerObservedConfig();
    
  }
  public interface AuthenticationObservedConfigNested<N> extends Nested<N>,AuthenticationFluent<NetworkSpecFluent.AuthenticationObservedConfigNested<N>>{
    public N and();
    public N endAuthenticationObservedConfig();
    
  }
  public interface ImagePrunerUnsupportedConfigOverridesNested<N> extends Nested<N>,ImagePrunerFluent<NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endImagePrunerUnsupportedConfigOverrides();
    
  }
  public interface KubeControllerManagerUnsupportedConfigOverridesNested<N> extends Nested<N>,KubeControllerManagerFluent<NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endKubeControllerManagerUnsupportedConfigOverrides();
    
  }
  public interface StorageUnsupportedConfigOverridesNested<N> extends Nested<N>,StorageFluent<NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endStorageUnsupportedConfigOverrides();
    
  }
  public interface ImageContentSourcePolicyUnsupportedConfigOverridesNested<N> extends Nested<N>,ImageContentSourcePolicyFluent<NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endImageContentSourcePolicyUnsupportedConfigOverrides();
    
  }
  public interface ServiceCAUnsupportedConfigOverridesNested<N> extends Nested<N>,ServiceCAFluent<NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endServiceCAUnsupportedConfigOverrides();
    
  }
  public interface ConfigUnsupportedConfigOverridesNested<N> extends Nested<N>,ConfigFluent<NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endConfigUnsupportedConfigOverrides();
    
  }
  public interface PersistentVolumeClaimUnsupportedConfigOverridesNested<N> extends Nested<N>,PersistentVolumeClaimFluent<NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endPersistentVolumeClaimUnsupportedConfigOverrides();
    
  }
  public interface KubeAPIServerUnsupportedConfigOverridesNested<N> extends Nested<N>,KubeAPIServerFluent<NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endKubeAPIServerUnsupportedConfigOverrides();
    
  }
  public interface IngressControllerUnsupportedConfigOverridesNested<N> extends Nested<N>,IngressControllerFluent<NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endIngressControllerUnsupportedConfigOverrides();
    
  }
  public interface KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N> extends Nested<N>,KubeStorageVersionMigratorFluent<NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides();
    
  }
  public interface ConsoleUnsupportedConfigOverridesNested<N> extends Nested<N>,ConsoleFluent<NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endConsoleUnsupportedConfigOverrides();
    
  }
  public interface ClusterCSIDriverUnsupportedConfigOverridesNested<N> extends Nested<N>,ClusterCSIDriverFluent<NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endClusterCSIDriverUnsupportedConfigOverrides();
    
  }
  public interface OpenShiftControllerManagerUnsupportedConfigOverridesNested<N> extends Nested<N>,OpenShiftControllerManagerFluent<NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides();
    
  }
  public interface EtcdUnsupportedConfigOverridesNested<N> extends Nested<N>,EtcdFluent<NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endEtcdUnsupportedConfigOverrides();
    
  }
  public interface CloudCredentialUnsupportedConfigOverridesNested<N> extends Nested<N>,CloudCredentialFluent<NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endCloudCredentialUnsupportedConfigOverrides();
    
  }
  public interface KubeSchedulerUnsupportedConfigOverridesNested<N> extends Nested<N>,KubeSchedulerFluent<NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endKubeSchedulerUnsupportedConfigOverrides();
    
  }
  public interface NetworkUnsupportedConfigOverridesNested<N> extends Nested<N>,NetworkFluent<NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endNetworkUnsupportedConfigOverrides();
    
  }
  public interface ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N> extends Nested<N>,ServiceCatalogAPIServerFluent<NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides();
    
  }
  public interface PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N> extends Nested<N>,PodNetworkConnectivityCheckFluent<NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides();
    
  }
  public interface CSISnapshotControllerUnsupportedConfigOverridesNested<N> extends Nested<N>,CSISnapshotControllerFluent<NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endCSISnapshotControllerUnsupportedConfigOverrides();
    
  }
  public interface ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N> extends Nested<N>,ServiceCatalogControllerManagerFluent<NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides();
    
  }
  public interface DNSUnsupportedConfigOverridesNested<N> extends Nested<N>,DNSFluent<NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endDNSUnsupportedConfigOverrides();
    
  }
  public interface DNSRecordUnsupportedConfigOverridesNested<N> extends Nested<N>,DNSRecordFluent<NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endDNSRecordUnsupportedConfigOverrides();
    
  }
  public interface OpenShiftAPIServerUnsupportedConfigOverridesNested<N> extends Nested<N>,OpenShiftAPIServerFluent<NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endOpenShiftAPIServerUnsupportedConfigOverrides();
    
  }
  public interface AuthenticationUnsupportedConfigOverridesNested<N> extends Nested<N>,AuthenticationFluent<NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>>{
    public N and();
    public N endAuthenticationUnsupportedConfigOverrides();
    
  }
  
}