package io.fabric8.openshift.api.model.operator.v1;

import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfile;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressControllerSpecFluentImpl<A extends IngressControllerSpecFluent<A>> extends BaseFluent<A> implements IngressControllerSpecFluent<A>{
  public IngressControllerSpecFluentImpl() {
  }
  public IngressControllerSpecFluentImpl(IngressControllerSpec instance) {
    this.withClientTLS(instance.getClientTLS()); 
    this.withDefaultCertificate(instance.getDefaultCertificate()); 
    this.withDomain(instance.getDomain()); 
    this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
    this.withHttpCompression(instance.getHttpCompression()); 
    this.withHttpEmptyRequestsPolicy(instance.getHttpEmptyRequestsPolicy()); 
    this.withHttpErrorCodePages(instance.getHttpErrorCodePages()); 
    this.withHttpHeaders(instance.getHttpHeaders()); 
    this.withLogging(instance.getLogging()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withNodePlacement(instance.getNodePlacement()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRouteAdmission(instance.getRouteAdmission()); 
    this.withRouteSelector(instance.getRouteSelector()); 
    this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    this.withTuningOptions(instance.getTuningOptions()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ClientTLSBuilder clientTLS;
  private LocalObjectReferenceBuilder defaultCertificate;
  private String domain;
  private EndpointPublishingStrategyBuilder endpointPublishingStrategy;
  private HTTPCompressionPolicyBuilder httpCompression;
  private String httpEmptyRequestsPolicy;
  private ConfigMapNameReference httpErrorCodePages;
  private IngressControllerHTTPHeadersBuilder httpHeaders;
  private IngressControllerLoggingBuilder logging;
  private LabelSelectorBuilder namespaceSelector;
  private NodePlacementBuilder nodePlacement;
  private Integer replicas;
  private RouteAdmissionPolicyBuilder routeAdmission;
  private LabelSelectorBuilder routeSelector;
  private TLSSecurityProfile tlsSecurityProfile;
  private IngressControllerTuningOptionsBuilder tuningOptions;
  private VisitableBuilder<? extends HasMetadata,?> unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildClientTLS instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClientTLS getClientTLS() {
    return this.clientTLS!=null ?this.clientTLS.build():null;
  }
  public ClientTLS buildClientTLS() {
    return this.clientTLS!=null ?this.clientTLS.build():null;
  }
  public A withClientTLS(ClientTLS clientTLS) {
    _visitables.get("clientTLS").remove(this.clientTLS);
    if (clientTLS!=null){ this.clientTLS= new ClientTLSBuilder(clientTLS); _visitables.get("clientTLS").add(this.clientTLS);} else { this.clientTLS = null; _visitables.get("clientTLS").remove(this.clientTLS); } return (A) this;
  }
  public Boolean hasClientTLS() {
    return this.clientTLS != null;
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> withNewClientTLS() {
    return new IngressControllerSpecFluentImpl.ClientTLSNestedImpl();
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> withNewClientTLSLike(ClientTLS item) {
    return new IngressControllerSpecFluentImpl.ClientTLSNestedImpl(item);
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> editClientTLS() {
    return withNewClientTLSLike(getClientTLS());
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> editOrNewClientTLS() {
    return withNewClientTLSLike(getClientTLS() != null ? getClientTLS(): new ClientTLSBuilder().build());
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> editOrNewClientTLSLike(ClientTLS item) {
    return withNewClientTLSLike(getClientTLS() != null ? getClientTLS(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultCertificate instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getDefaultCertificate() {
    return this.defaultCertificate!=null ?this.defaultCertificate.build():null;
  }
  public LocalObjectReference buildDefaultCertificate() {
    return this.defaultCertificate!=null ?this.defaultCertificate.build():null;
  }
  public A withDefaultCertificate(LocalObjectReference defaultCertificate) {
    _visitables.get("defaultCertificate").remove(this.defaultCertificate);
    if (defaultCertificate!=null){ this.defaultCertificate= new LocalObjectReferenceBuilder(defaultCertificate); _visitables.get("defaultCertificate").add(this.defaultCertificate);} else { this.defaultCertificate = null; _visitables.get("defaultCertificate").remove(this.defaultCertificate); } return (A) this;
  }
  public Boolean hasDefaultCertificate() {
    return this.defaultCertificate != null;
  }
  public A withNewDefaultCertificate(String name) {
    return (A)withDefaultCertificate(new LocalObjectReference(name));
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> withNewDefaultCertificate() {
    return new IngressControllerSpecFluentImpl.DefaultCertificateNestedImpl();
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> withNewDefaultCertificateLike(LocalObjectReference item) {
    return new IngressControllerSpecFluentImpl.DefaultCertificateNestedImpl(item);
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> editDefaultCertificate() {
    return withNewDefaultCertificateLike(getDefaultCertificate());
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> editOrNewDefaultCertificate() {
    return withNewDefaultCertificateLike(getDefaultCertificate() != null ? getDefaultCertificate(): new LocalObjectReferenceBuilder().build());
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> editOrNewDefaultCertificateLike(LocalObjectReference item) {
    return withNewDefaultCertificateLike(getDefaultCertificate() != null ? getDefaultCertificate(): item);
  }
  public String getDomain() {
    return this.domain;
  }
  public A withDomain(String domain) {
    this.domain=domain; return (A) this;
  }
  public Boolean hasDomain() {
    return this.domain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointPublishingStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointPublishingStrategy getEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy!=null ?this.endpointPublishingStrategy.build():null;
  }
  public EndpointPublishingStrategy buildEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy!=null ?this.endpointPublishingStrategy.build():null;
  }
  public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
    _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
    if (endpointPublishingStrategy!=null){ this.endpointPublishingStrategy= new EndpointPublishingStrategyBuilder(endpointPublishingStrategy); _visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);} else { this.endpointPublishingStrategy = null; _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy); } return (A) this;
  }
  public Boolean hasEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy != null;
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
    return new IngressControllerSpecFluentImpl.EndpointPublishingStrategyNestedImpl();
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return new IngressControllerSpecFluentImpl.EndpointPublishingStrategyNestedImpl(item);
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy());
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): new EndpointPublishingStrategyBuilder().build());
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHttpCompression instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPCompressionPolicy getHttpCompression() {
    return this.httpCompression!=null ?this.httpCompression.build():null;
  }
  public HTTPCompressionPolicy buildHttpCompression() {
    return this.httpCompression!=null ?this.httpCompression.build():null;
  }
  public A withHttpCompression(HTTPCompressionPolicy httpCompression) {
    _visitables.get("httpCompression").remove(this.httpCompression);
    if (httpCompression!=null){ this.httpCompression= new HTTPCompressionPolicyBuilder(httpCompression); _visitables.get("httpCompression").add(this.httpCompression);} else { this.httpCompression = null; _visitables.get("httpCompression").remove(this.httpCompression); } return (A) this;
  }
  public Boolean hasHttpCompression() {
    return this.httpCompression != null;
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> withNewHttpCompression() {
    return new IngressControllerSpecFluentImpl.HttpCompressionNestedImpl();
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> withNewHttpCompressionLike(HTTPCompressionPolicy item) {
    return new IngressControllerSpecFluentImpl.HttpCompressionNestedImpl(item);
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> editHttpCompression() {
    return withNewHttpCompressionLike(getHttpCompression());
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> editOrNewHttpCompression() {
    return withNewHttpCompressionLike(getHttpCompression() != null ? getHttpCompression(): new HTTPCompressionPolicyBuilder().build());
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> editOrNewHttpCompressionLike(HTTPCompressionPolicy item) {
    return withNewHttpCompressionLike(getHttpCompression() != null ? getHttpCompression(): item);
  }
  public String getHttpEmptyRequestsPolicy() {
    return this.httpEmptyRequestsPolicy;
  }
  public A withHttpEmptyRequestsPolicy(String httpEmptyRequestsPolicy) {
    this.httpEmptyRequestsPolicy=httpEmptyRequestsPolicy; return (A) this;
  }
  public Boolean hasHttpEmptyRequestsPolicy() {
    return this.httpEmptyRequestsPolicy != null;
  }
  public ConfigMapNameReference getHttpErrorCodePages() {
    return this.httpErrorCodePages;
  }
  public A withHttpErrorCodePages(ConfigMapNameReference httpErrorCodePages) {
    this.httpErrorCodePages=httpErrorCodePages; return (A) this;
  }
  public Boolean hasHttpErrorCodePages() {
    return this.httpErrorCodePages != null;
  }
  public A withNewHttpErrorCodePages(String name) {
    return (A)withHttpErrorCodePages(new ConfigMapNameReference(name));
  }
  
  /**
   * This method has been deprecated, please use method buildHttpHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressControllerHTTPHeaders getHttpHeaders() {
    return this.httpHeaders!=null ?this.httpHeaders.build():null;
  }
  public IngressControllerHTTPHeaders buildHttpHeaders() {
    return this.httpHeaders!=null ?this.httpHeaders.build():null;
  }
  public A withHttpHeaders(IngressControllerHTTPHeaders httpHeaders) {
    _visitables.get("httpHeaders").remove(this.httpHeaders);
    if (httpHeaders!=null){ this.httpHeaders= new IngressControllerHTTPHeadersBuilder(httpHeaders); _visitables.get("httpHeaders").add(this.httpHeaders);} else { this.httpHeaders = null; _visitables.get("httpHeaders").remove(this.httpHeaders); } return (A) this;
  }
  public Boolean hasHttpHeaders() {
    return this.httpHeaders != null;
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> withNewHttpHeaders() {
    return new IngressControllerSpecFluentImpl.HttpHeadersNestedImpl();
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> withNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
    return new IngressControllerSpecFluentImpl.HttpHeadersNestedImpl(item);
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> editHttpHeaders() {
    return withNewHttpHeadersLike(getHttpHeaders());
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> editOrNewHttpHeaders() {
    return withNewHttpHeadersLike(getHttpHeaders() != null ? getHttpHeaders(): new IngressControllerHTTPHeadersBuilder().build());
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> editOrNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
    return withNewHttpHeadersLike(getHttpHeaders() != null ? getHttpHeaders(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLogging instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressControllerLogging getLogging() {
    return this.logging!=null ?this.logging.build():null;
  }
  public IngressControllerLogging buildLogging() {
    return this.logging!=null ?this.logging.build():null;
  }
  public A withLogging(IngressControllerLogging logging) {
    _visitables.get("logging").remove(this.logging);
    if (logging!=null){ this.logging= new IngressControllerLoggingBuilder(logging); _visitables.get("logging").add(this.logging);} else { this.logging = null; _visitables.get("logging").remove(this.logging); } return (A) this;
  }
  public Boolean hasLogging() {
    return this.logging != null;
  }
  public IngressControllerSpecFluent.LoggingNested<A> withNewLogging() {
    return new IngressControllerSpecFluentImpl.LoggingNestedImpl();
  }
  public IngressControllerSpecFluent.LoggingNested<A> withNewLoggingLike(IngressControllerLogging item) {
    return new IngressControllerSpecFluentImpl.LoggingNestedImpl(item);
  }
  public IngressControllerSpecFluent.LoggingNested<A> editLogging() {
    return withNewLoggingLike(getLogging());
  }
  public IngressControllerSpecFluent.LoggingNested<A> editOrNewLogging() {
    return withNewLoggingLike(getLogging() != null ? getLogging(): new IngressControllerLoggingBuilder().build());
  }
  public IngressControllerSpecFluent.LoggingNested<A> editOrNewLoggingLike(IngressControllerLogging item) {
    return withNewLoggingLike(getLogging() != null ? getLogging(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new IngressControllerSpecFluentImpl.NamespaceSelectorNestedImpl();
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new IngressControllerSpecFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodePlacement instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodePlacement getNodePlacement() {
    return this.nodePlacement!=null ?this.nodePlacement.build():null;
  }
  public NodePlacement buildNodePlacement() {
    return this.nodePlacement!=null ?this.nodePlacement.build():null;
  }
  public A withNodePlacement(NodePlacement nodePlacement) {
    _visitables.get("nodePlacement").remove(this.nodePlacement);
    if (nodePlacement!=null){ this.nodePlacement= new NodePlacementBuilder(nodePlacement); _visitables.get("nodePlacement").add(this.nodePlacement);} else { this.nodePlacement = null; _visitables.get("nodePlacement").remove(this.nodePlacement); } return (A) this;
  }
  public Boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> withNewNodePlacement() {
    return new IngressControllerSpecFluentImpl.NodePlacementNestedImpl();
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
    return new IngressControllerSpecFluentImpl.NodePlacementNestedImpl(item);
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(getNodePlacement());
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): new NodePlacementBuilder().build());
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
    return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): item);
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRouteAdmission instead.
   * @return The buildable object.
   */
  @Deprecated
  public RouteAdmissionPolicy getRouteAdmission() {
    return this.routeAdmission!=null ?this.routeAdmission.build():null;
  }
  public RouteAdmissionPolicy buildRouteAdmission() {
    return this.routeAdmission!=null ?this.routeAdmission.build():null;
  }
  public A withRouteAdmission(RouteAdmissionPolicy routeAdmission) {
    _visitables.get("routeAdmission").remove(this.routeAdmission);
    if (routeAdmission!=null){ this.routeAdmission= new RouteAdmissionPolicyBuilder(routeAdmission); _visitables.get("routeAdmission").add(this.routeAdmission);} else { this.routeAdmission = null; _visitables.get("routeAdmission").remove(this.routeAdmission); } return (A) this;
  }
  public Boolean hasRouteAdmission() {
    return this.routeAdmission != null;
  }
  public A withNewRouteAdmission(String namespaceOwnership,String wildcardPolicy) {
    return (A)withRouteAdmission(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> withNewRouteAdmission() {
    return new IngressControllerSpecFluentImpl.RouteAdmissionNestedImpl();
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> withNewRouteAdmissionLike(RouteAdmissionPolicy item) {
    return new IngressControllerSpecFluentImpl.RouteAdmissionNestedImpl(item);
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> editRouteAdmission() {
    return withNewRouteAdmissionLike(getRouteAdmission());
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> editOrNewRouteAdmission() {
    return withNewRouteAdmissionLike(getRouteAdmission() != null ? getRouteAdmission(): new RouteAdmissionPolicyBuilder().build());
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> editOrNewRouteAdmissionLike(RouteAdmissionPolicy item) {
    return withNewRouteAdmissionLike(getRouteAdmission() != null ? getRouteAdmission(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRouteSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRouteSelector() {
    return this.routeSelector!=null ?this.routeSelector.build():null;
  }
  public LabelSelector buildRouteSelector() {
    return this.routeSelector!=null ?this.routeSelector.build():null;
  }
  public A withRouteSelector(LabelSelector routeSelector) {
    _visitables.get("routeSelector").remove(this.routeSelector);
    if (routeSelector!=null){ this.routeSelector= new LabelSelectorBuilder(routeSelector); _visitables.get("routeSelector").add(this.routeSelector);} else { this.routeSelector = null; _visitables.get("routeSelector").remove(this.routeSelector); } return (A) this;
  }
  public Boolean hasRouteSelector() {
    return this.routeSelector != null;
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> withNewRouteSelector() {
    return new IngressControllerSpecFluentImpl.RouteSelectorNestedImpl();
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
    return new IngressControllerSpecFluentImpl.RouteSelectorNestedImpl(item);
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> editRouteSelector() {
    return withNewRouteSelectorLike(getRouteSelector());
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> editOrNewRouteSelector() {
    return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): new LabelSelectorBuilder().build());
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
    return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): item);
  }
  public TLSSecurityProfile getTlsSecurityProfile() {
    return this.tlsSecurityProfile;
  }
  public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
    this.tlsSecurityProfile=tlsSecurityProfile; return (A) this;
  }
  public Boolean hasTlsSecurityProfile() {
    return this.tlsSecurityProfile != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTuningOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressControllerTuningOptions getTuningOptions() {
    return this.tuningOptions!=null ?this.tuningOptions.build():null;
  }
  public IngressControllerTuningOptions buildTuningOptions() {
    return this.tuningOptions!=null ?this.tuningOptions.build():null;
  }
  public A withTuningOptions(IngressControllerTuningOptions tuningOptions) {
    _visitables.get("tuningOptions").remove(this.tuningOptions);
    if (tuningOptions!=null){ this.tuningOptions= new IngressControllerTuningOptionsBuilder(tuningOptions); _visitables.get("tuningOptions").add(this.tuningOptions);} else { this.tuningOptions = null; _visitables.get("tuningOptions").remove(this.tuningOptions); } return (A) this;
  }
  public Boolean hasTuningOptions() {
    return this.tuningOptions != null;
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> withNewTuningOptions() {
    return new IngressControllerSpecFluentImpl.TuningOptionsNestedImpl();
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> withNewTuningOptionsLike(IngressControllerTuningOptions item) {
    return new IngressControllerSpecFluentImpl.TuningOptionsNestedImpl(item);
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> editTuningOptions() {
    return withNewTuningOptionsLike(getTuningOptions());
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> editOrNewTuningOptions() {
    return withNewTuningOptionsLike(getTuningOptions() != null ? getTuningOptions(): new IngressControllerTuningOptionsBuilder().build());
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> editOrNewTuningOptionsLike(IngressControllerTuningOptions item) {
    return withNewTuningOptionsLike(getTuningOptions() != null ? getTuningOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public HasMetadata buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides instanceof ImagePruner){ this.unsupportedConfigOverrides= new ImagePrunerBuilder((ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManager){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder((KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Storage){ this.unsupportedConfigOverrides= new StorageBuilder((Storage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCA){ this.unsupportedConfigOverrides= new ServiceCABuilder((ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Config){ this.unsupportedConfigOverrides= new ConfigBuilder((Config)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PersistentVolumeClaim){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServer){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder((KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressController){ this.unsupportedConfigOverrides= new IngressControllerBuilder((IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Console){ this.unsupportedConfigOverrides= new ConsoleBuilder((Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriver){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder((ClusterCSIDriver)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManager){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Etcd){ this.unsupportedConfigOverrides= new EtcdBuilder((Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredential){ this.unsupportedConfigOverrides= new CloudCredentialBuilder((CloudCredential)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeScheduler){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder((KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Network){ this.unsupportedConfigOverrides= new NetworkBuilder((Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheck){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotController){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder((CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNS){ this.unsupportedConfigOverrides= new DNSBuilder((DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecord){ this.unsupportedConfigOverrides= new DNSRecordBuilder((DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServer){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Authentication){ this.unsupportedConfigOverrides= new AuthenticationBuilder((Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    return (A) this;
  }
  public Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
    return new IngressControllerSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageUnsupportedConfigOverrides(Storage storageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageBuilder(storageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item) {
    return new IngressControllerSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
    return new IngressControllerSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
    return new IngressControllerSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigUnsupportedConfigOverrides(Config configUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigBuilder(configUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item) {
    return new IngressControllerSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
    return new IngressControllerSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
    return new IngressControllerSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
    return new IngressControllerSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
    return new IngressControllerSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverUnsupportedConfigOverrides(ClusterCSIDriver clusterCSIDriverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder(clusterCSIDriverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item) {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
    return new IngressControllerSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCloudCredentialUnsupportedConfigOverrides(CloudCredential cloudCredentialUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialBuilder(cloudCredentialUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item) {
    return new IngressControllerSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
    return new IngressControllerSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
    return new IngressControllerSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckUnsupportedConfigOverrides(PodNetworkConnectivityCheck podNetworkConnectivityCheckUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item) {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
    return new IngressControllerSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
    return new IngressControllerSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
    return new IngressControllerSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressControllerSpecFluentImpl that = (IngressControllerSpecFluentImpl) o;
    if (clientTLS != null ? !clientTLS.equals(that.clientTLS) :that.clientTLS != null) return false;
    if (defaultCertificate != null ? !defaultCertificate.equals(that.defaultCertificate) :that.defaultCertificate != null) return false;
    if (domain != null ? !domain.equals(that.domain) :that.domain != null) return false;
    if (endpointPublishingStrategy != null ? !endpointPublishingStrategy.equals(that.endpointPublishingStrategy) :that.endpointPublishingStrategy != null) return false;
    if (httpCompression != null ? !httpCompression.equals(that.httpCompression) :that.httpCompression != null) return false;
    if (httpEmptyRequestsPolicy != null ? !httpEmptyRequestsPolicy.equals(that.httpEmptyRequestsPolicy) :that.httpEmptyRequestsPolicy != null) return false;
    if (httpErrorCodePages != null ? !httpErrorCodePages.equals(that.httpErrorCodePages) :that.httpErrorCodePages != null) return false;
    if (httpHeaders != null ? !httpHeaders.equals(that.httpHeaders) :that.httpHeaders != null) return false;
    if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (nodePlacement != null ? !nodePlacement.equals(that.nodePlacement) :that.nodePlacement != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (routeAdmission != null ? !routeAdmission.equals(that.routeAdmission) :that.routeAdmission != null) return false;
    if (routeSelector != null ? !routeSelector.equals(that.routeSelector) :that.routeSelector != null) return false;
    if (tlsSecurityProfile != null ? !tlsSecurityProfile.equals(that.tlsSecurityProfile) :that.tlsSecurityProfile != null) return false;
    if (tuningOptions != null ? !tuningOptions.equals(that.tuningOptions) :that.tuningOptions != null) return false;
    if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientTLS,  defaultCertificate,  domain,  endpointPublishingStrategy,  httpCompression,  httpEmptyRequestsPolicy,  httpErrorCodePages,  httpHeaders,  logging,  namespaceSelector,  nodePlacement,  replicas,  routeAdmission,  routeSelector,  tlsSecurityProfile,  tuningOptions,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientTLS != null) { sb.append("clientTLS:"); sb.append(clientTLS + ","); }
    if (defaultCertificate != null) { sb.append("defaultCertificate:"); sb.append(defaultCertificate + ","); }
    if (domain != null) { sb.append("domain:"); sb.append(domain + ","); }
    if (endpointPublishingStrategy != null) { sb.append("endpointPublishingStrategy:"); sb.append(endpointPublishingStrategy + ","); }
    if (httpCompression != null) { sb.append("httpCompression:"); sb.append(httpCompression + ","); }
    if (httpEmptyRequestsPolicy != null) { sb.append("httpEmptyRequestsPolicy:"); sb.append(httpEmptyRequestsPolicy + ","); }
    if (httpErrorCodePages != null) { sb.append("httpErrorCodePages:"); sb.append(httpErrorCodePages + ","); }
    if (httpHeaders != null) { sb.append("httpHeaders:"); sb.append(httpHeaders + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (routeAdmission != null) { sb.append("routeAdmission:"); sb.append(routeAdmission + ","); }
    if (routeSelector != null) { sb.append("routeSelector:"); sb.append(routeSelector + ","); }
    if (tlsSecurityProfile != null) { sb.append("tlsSecurityProfile:"); sb.append(tlsSecurityProfile + ","); }
    if (tuningOptions != null) { sb.append("tuningOptions:"); sb.append(tuningOptions + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClientTLSNestedImpl<N> extends ClientTLSFluentImpl<IngressControllerSpecFluent.ClientTLSNested<N>> implements IngressControllerSpecFluent.ClientTLSNested<N>,Nested<N>{
    ClientTLSNestedImpl(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSNestedImpl() {
      this.builder = new ClientTLSBuilder(this);
    }
    ClientTLSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withClientTLS(builder.build());
    }
    public N endClientTLS() {
      return and();
    }
    
  }
  class DefaultCertificateNestedImpl<N> extends LocalObjectReferenceFluentImpl<IngressControllerSpecFluent.DefaultCertificateNested<N>> implements IngressControllerSpecFluent.DefaultCertificateNested<N>,Nested<N>{
    DefaultCertificateNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    DefaultCertificateNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withDefaultCertificate(builder.build());
    }
    public N endDefaultCertificate() {
      return and();
    }
    
  }
  class EndpointPublishingStrategyNestedImpl<N> extends EndpointPublishingStrategyFluentImpl<IngressControllerSpecFluent.EndpointPublishingStrategyNested<N>> implements IngressControllerSpecFluent.EndpointPublishingStrategyNested<N>,Nested<N>{
    EndpointPublishingStrategyNestedImpl(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyNestedImpl() {
      this.builder = new EndpointPublishingStrategyBuilder(this);
    }
    EndpointPublishingStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withEndpointPublishingStrategy(builder.build());
    }
    public N endEndpointPublishingStrategy() {
      return and();
    }
    
  }
  class HttpCompressionNestedImpl<N> extends HTTPCompressionPolicyFluentImpl<IngressControllerSpecFluent.HttpCompressionNested<N>> implements IngressControllerSpecFluent.HttpCompressionNested<N>,Nested<N>{
    HttpCompressionNestedImpl(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HttpCompressionNestedImpl() {
      this.builder = new HTTPCompressionPolicyBuilder(this);
    }
    HTTPCompressionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withHttpCompression(builder.build());
    }
    public N endHttpCompression() {
      return and();
    }
    
  }
  class HttpHeadersNestedImpl<N> extends IngressControllerHTTPHeadersFluentImpl<IngressControllerSpecFluent.HttpHeadersNested<N>> implements IngressControllerSpecFluent.HttpHeadersNested<N>,Nested<N>{
    HttpHeadersNestedImpl(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    HttpHeadersNestedImpl() {
      this.builder = new IngressControllerHTTPHeadersBuilder(this);
    }
    IngressControllerHTTPHeadersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withHttpHeaders(builder.build());
    }
    public N endHttpHeaders() {
      return and();
    }
    
  }
  class LoggingNestedImpl<N> extends IngressControllerLoggingFluentImpl<IngressControllerSpecFluent.LoggingNested<N>> implements IngressControllerSpecFluent.LoggingNested<N>,Nested<N>{
    LoggingNestedImpl(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    LoggingNestedImpl() {
      this.builder = new IngressControllerLoggingBuilder(this);
    }
    IngressControllerLoggingBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withLogging(builder.build());
    }
    public N endLogging() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<IngressControllerSpecFluent.NamespaceSelectorNested<N>> implements IngressControllerSpecFluent.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class NodePlacementNestedImpl<N> extends NodePlacementFluentImpl<IngressControllerSpecFluent.NodePlacementNested<N>> implements IngressControllerSpecFluent.NodePlacementNested<N>,Nested<N>{
    NodePlacementNestedImpl(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementNestedImpl() {
      this.builder = new NodePlacementBuilder(this);
    }
    NodePlacementBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withNodePlacement(builder.build());
    }
    public N endNodePlacement() {
      return and();
    }
    
  }
  class RouteAdmissionNestedImpl<N> extends RouteAdmissionPolicyFluentImpl<IngressControllerSpecFluent.RouteAdmissionNested<N>> implements IngressControllerSpecFluent.RouteAdmissionNested<N>,Nested<N>{
    RouteAdmissionNestedImpl(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionNestedImpl() {
      this.builder = new RouteAdmissionPolicyBuilder(this);
    }
    RouteAdmissionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withRouteAdmission(builder.build());
    }
    public N endRouteAdmission() {
      return and();
    }
    
  }
  class RouteSelectorNestedImpl<N> extends LabelSelectorFluentImpl<IngressControllerSpecFluent.RouteSelectorNested<N>> implements IngressControllerSpecFluent.RouteSelectorNested<N>,Nested<N>{
    RouteSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    RouteSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withRouteSelector(builder.build());
    }
    public N endRouteSelector() {
      return and();
    }
    
  }
  class TuningOptionsNestedImpl<N> extends IngressControllerTuningOptionsFluentImpl<IngressControllerSpecFluent.TuningOptionsNested<N>> implements IngressControllerSpecFluent.TuningOptionsNested<N>,Nested<N>{
    TuningOptionsNestedImpl(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    TuningOptionsNestedImpl() {
      this.builder = new IngressControllerTuningOptionsBuilder(this);
    }
    IngressControllerTuningOptionsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withTuningOptions(builder.build());
    }
    public N endTuningOptions() {
      return and();
    }
    
  }
  class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerFluentImpl<IngressControllerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerFluentImpl<IngressControllerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageUnsupportedConfigOverridesNestedImpl<N> extends StorageFluentImpl<IngressControllerSpecFluent.StorageUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.StorageUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageUnsupportedConfigOverridesNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<IngressControllerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAFluentImpl<IngressControllerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAUnsupportedConfigOverridesNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigUnsupportedConfigOverridesNestedImpl<N> extends ConfigFluentImpl<IngressControllerSpecFluent.ConfigUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConfigUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigUnsupportedConfigOverridesNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<IngressControllerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerFluentImpl<IngressControllerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerFluentImpl<IngressControllerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerUnsupportedConfigOverridesNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<IngressControllerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends ConsoleFluentImpl<IngressControllerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleUnsupportedConfigOverridesNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverFluentImpl<IngressControllerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<IngressControllerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdUnsupportedConfigOverridesNestedImpl<N> extends EtcdFluentImpl<IngressControllerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdUnsupportedConfigOverridesNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CloudCredentialUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialFluentImpl<IngressControllerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerFluentImpl<IngressControllerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkUnsupportedConfigOverridesNestedImpl<N> extends NetworkFluentImpl<IngressControllerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkUnsupportedConfigOverridesNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<IngressControllerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<IngressControllerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerFluentImpl<IngressControllerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<IngressControllerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSUnsupportedConfigOverridesNestedImpl<N> extends DNSFluentImpl<IngressControllerSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSUnsupportedConfigOverridesNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordFluentImpl<IngressControllerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordUnsupportedConfigOverridesNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerFluentImpl<IngressControllerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationFluentImpl<IngressControllerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationUnsupportedConfigOverridesNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  
}