package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSZoneConditionBuilder extends DNSZoneConditionFluentImpl<DNSZoneConditionBuilder> implements VisitableBuilder<DNSZoneCondition,DNSZoneConditionBuilder>{
  public DNSZoneConditionBuilder() {
    this(false);
  }
  public DNSZoneConditionBuilder(Boolean validationEnabled) {
    this(new DNSZoneCondition(), validationEnabled);
  }
  public DNSZoneConditionBuilder(DNSZoneConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSZoneConditionBuilder(DNSZoneConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSZoneCondition(), validationEnabled);
  }
  public DNSZoneConditionBuilder(DNSZoneConditionFluent<?> fluent,DNSZoneCondition instance) {
    this(fluent, instance, false);
  }
  public DNSZoneConditionBuilder(DNSZoneConditionFluent<?> fluent,DNSZoneCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DNSZoneConditionBuilder(DNSZoneCondition instance) {
    this(instance,false);
  }
  public DNSZoneConditionBuilder(DNSZoneCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  DNSZoneConditionFluent<?> fluent;
  Boolean validationEnabled;
  public DNSZoneCondition build() {
    DNSZoneCondition buildable = new DNSZoneCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}