package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import java.lang.Integer;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConsoleSpecFluentImpl<A extends ConsoleSpecFluent<A>> extends BaseFluent<A> implements ConsoleSpecFluent<A>{
  public ConsoleSpecFluentImpl() {
  }
  public ConsoleSpecFluentImpl(ConsoleSpec instance) {
    this.withCustomization(instance.getCustomization()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withPlugins(instance.getPlugins()); 
    this.withProviders(instance.getProviders()); 
    this.withRoute(instance.getRoute()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConsoleCustomizationBuilder customization;
  private String logLevel;
  private String managementState;
  private VisitableBuilder<? extends HasMetadata,?> observedConfig;
  private String operatorLogLevel;
  private List<String> plugins = new ArrayList<String>();
  private ConsoleProvidersBuilder providers;
  private ConsoleConfigRouteBuilder route;
  private VisitableBuilder<? extends HasMetadata,?> unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCustomization instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConsoleCustomization getCustomization() {
    return this.customization!=null ?this.customization.build():null;
  }
  public ConsoleCustomization buildCustomization() {
    return this.customization!=null ?this.customization.build():null;
  }
  public A withCustomization(ConsoleCustomization customization) {
    _visitables.get("customization").remove(this.customization);
    if (customization!=null){ this.customization= new ConsoleCustomizationBuilder(customization); _visitables.get("customization").add(this.customization);} else { this.customization = null; _visitables.get("customization").remove(this.customization); } return (A) this;
  }
  public Boolean hasCustomization() {
    return this.customization != null;
  }
  public ConsoleSpecFluent.CustomizationNested<A> withNewCustomization() {
    return new ConsoleSpecFluentImpl.CustomizationNestedImpl();
  }
  public ConsoleSpecFluent.CustomizationNested<A> withNewCustomizationLike(ConsoleCustomization item) {
    return new ConsoleSpecFluentImpl.CustomizationNestedImpl(item);
  }
  public ConsoleSpecFluent.CustomizationNested<A> editCustomization() {
    return withNewCustomizationLike(getCustomization());
  }
  public ConsoleSpecFluent.CustomizationNested<A> editOrNewCustomization() {
    return withNewCustomizationLike(getCustomization() != null ? getCustomization(): new ConsoleCustomizationBuilder().build());
  }
  public ConsoleSpecFluent.CustomizationNested<A> editOrNewCustomizationLike(ConsoleCustomization item) {
    return withNewCustomizationLike(getCustomization() != null ? getCustomization(): item);
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public Boolean hasManagementState() {
    return this.managementState != null;
  }
  
  /**
   * This method has been deprecated, please use method buildObservedConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public HasMetadata buildObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public A withObservedConfig(HasMetadata observedConfig) {
    if (observedConfig instanceof ImagePruner){ this.observedConfig= new ImagePrunerBuilder((ImagePruner)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeControllerManager){ this.observedConfig= new KubeControllerManagerBuilder((KubeControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Storage){ this.observedConfig= new StorageBuilder((Storage)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImageContentSourcePolicy){ this.observedConfig= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCA){ this.observedConfig= new ServiceCABuilder((ServiceCA)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Config){ this.observedConfig= new ConfigBuilder((Config)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PersistentVolumeClaim){ this.observedConfig= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeAPIServer){ this.observedConfig= new KubeAPIServerBuilder((KubeAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressController){ this.observedConfig= new IngressControllerBuilder((IngressController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeStorageVersionMigrator){ this.observedConfig= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Console){ this.observedConfig= new ConsoleBuilder((Console)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClusterCSIDriver){ this.observedConfig= new ClusterCSIDriverBuilder((ClusterCSIDriver)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftControllerManager){ this.observedConfig= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Etcd){ this.observedConfig= new EtcdBuilder((Etcd)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CloudCredential){ this.observedConfig= new CloudCredentialBuilder((CloudCredential)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeScheduler){ this.observedConfig= new KubeSchedulerBuilder((KubeScheduler)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Network){ this.observedConfig= new NetworkBuilder((Network)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogAPIServer){ this.observedConfig= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodNetworkConnectivityCheck){ this.observedConfig= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CSISnapshotController){ this.observedConfig= new CSISnapshotControllerBuilder((CSISnapshotController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogControllerManager){ this.observedConfig= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNS){ this.observedConfig= new DNSBuilder((DNS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSRecord){ this.observedConfig= new DNSRecordBuilder((DNSRecord)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftAPIServer){ this.observedConfig= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Authentication){ this.observedConfig= new AuthenticationBuilder((Authentication)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    return (A) this;
  }
  public Boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imagePrunerObservedConfig!=null){ this.observedConfig= new ImagePrunerBuilder(imagePrunerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig() {
    return new ConsoleSpecFluentImpl.ImagePrunerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item) {
    return new ConsoleSpecFluentImpl.ImagePrunerObservedConfigNestedImpl(item);
  }
  public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeControllerManagerObservedConfig!=null){ this.observedConfig= new KubeControllerManagerBuilder(kubeControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig() {
    return new ConsoleSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item) {
    return new ConsoleSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl(item);
  }
  public A withStorageObservedConfig(Storage storageObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (storageObservedConfig!=null){ this.observedConfig= new StorageBuilder(storageObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfig() {
    return new ConsoleSpecFluentImpl.StorageObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfigLike(Storage item) {
    return new ConsoleSpecFluentImpl.StorageObservedConfigNestedImpl(item);
  }
  public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imageContentSourcePolicyObservedConfig!=null){ this.observedConfig= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig() {
    return new ConsoleSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item) {
    return new ConsoleSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl(item);
  }
  public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCAObservedConfig!=null){ this.observedConfig= new ServiceCABuilder(serviceCAObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig() {
    return new ConsoleSpecFluentImpl.ServiceCAObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item) {
    return new ConsoleSpecFluentImpl.ServiceCAObservedConfigNestedImpl(item);
  }
  public A withConfigObservedConfig(Config configObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (configObservedConfig!=null){ this.observedConfig= new ConfigBuilder(configObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfig() {
    return new ConsoleSpecFluentImpl.ConfigObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfigLike(Config item) {
    return new ConsoleSpecFluentImpl.ConfigObservedConfigNestedImpl(item);
  }
  public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (persistentVolumeClaimObservedConfig!=null){ this.observedConfig= new PersistentVolumeClaimBuilder(persistentVolumeClaimObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig() {
    return new ConsoleSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item) {
    return new ConsoleSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl(item);
  }
  public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeAPIServerObservedConfig!=null){ this.observedConfig= new KubeAPIServerBuilder(kubeAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig() {
    return new ConsoleSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item) {
    return new ConsoleSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl(item);
  }
  public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerObservedConfig!=null){ this.observedConfig= new IngressControllerBuilder(ingressControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig() {
    return new ConsoleSpecFluentImpl.IngressControllerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item) {
    return new ConsoleSpecFluentImpl.IngressControllerObservedConfigNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeStorageVersionMigratorObservedConfig!=null){ this.observedConfig= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig() {
    return new ConsoleSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item) {
    return new ConsoleSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl(item);
  }
  public A withConsoleObservedConfig(Console consoleObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleObservedConfig!=null){ this.observedConfig= new ConsoleBuilder(consoleObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig() {
    return new ConsoleSpecFluentImpl.ConsoleObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item) {
    return new ConsoleSpecFluentImpl.ConsoleObservedConfigNestedImpl(item);
  }
  public A withClusterCSIDriverObservedConfig(ClusterCSIDriver clusterCSIDriverObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterCSIDriverObservedConfig!=null){ this.observedConfig= new ClusterCSIDriverBuilder(clusterCSIDriverObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfig() {
    return new ConsoleSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfigLike(ClusterCSIDriver item) {
    return new ConsoleSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl(item);
  }
  public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftControllerManagerObservedConfig!=null){ this.observedConfig= new OpenShiftControllerManagerBuilder(openShiftControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig() {
    return new ConsoleSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item) {
    return new ConsoleSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl(item);
  }
  public A withEtcdObservedConfig(Etcd etcdObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (etcdObservedConfig!=null){ this.observedConfig= new EtcdBuilder(etcdObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig() {
    return new ConsoleSpecFluentImpl.EtcdObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item) {
    return new ConsoleSpecFluentImpl.EtcdObservedConfigNestedImpl(item);
  }
  public A withCloudCredentialObservedConfig(CloudCredential cloudCredentialObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cloudCredentialObservedConfig!=null){ this.observedConfig= new CloudCredentialBuilder(cloudCredentialObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfig() {
    return new ConsoleSpecFluentImpl.CloudCredentialObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfigLike(CloudCredential item) {
    return new ConsoleSpecFluentImpl.CloudCredentialObservedConfigNestedImpl(item);
  }
  public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeSchedulerObservedConfig!=null){ this.observedConfig= new KubeSchedulerBuilder(kubeSchedulerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig() {
    return new ConsoleSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item) {
    return new ConsoleSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl(item);
  }
  public A withNetworkObservedConfig(Network networkObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkObservedConfig!=null){ this.observedConfig= new NetworkBuilder(networkObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig() {
    return new ConsoleSpecFluentImpl.NetworkObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item) {
    return new ConsoleSpecFluentImpl.NetworkObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogAPIServerObservedConfig!=null){ this.observedConfig= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig() {
    return new ConsoleSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item) {
    return new ConsoleSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckObservedConfig(PodNetworkConnectivityCheck podNetworkConnectivityCheckObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckObservedConfig!=null){ this.observedConfig= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfig() {
    return new ConsoleSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfigLike(PodNetworkConnectivityCheck item) {
    return new ConsoleSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl(item);
  }
  public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cSISnapshotControllerObservedConfig!=null){ this.observedConfig= new CSISnapshotControllerBuilder(cSISnapshotControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig() {
    return new ConsoleSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item) {
    return new ConsoleSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogControllerManagerObservedConfig!=null){ this.observedConfig= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig() {
    return new ConsoleSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item) {
    return new ConsoleSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl(item);
  }
  public A withDNSObservedConfig(DNS dNSObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSObservedConfig!=null){ this.observedConfig= new DNSBuilder(dNSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig() {
    return new ConsoleSpecFluentImpl.DNSObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item) {
    return new ConsoleSpecFluentImpl.DNSObservedConfigNestedImpl(item);
  }
  public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSRecordObservedConfig!=null){ this.observedConfig= new DNSRecordBuilder(dNSRecordObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig() {
    return new ConsoleSpecFluentImpl.DNSRecordObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item) {
    return new ConsoleSpecFluentImpl.DNSRecordObservedConfigNestedImpl(item);
  }
  public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftAPIServerObservedConfig!=null){ this.observedConfig= new OpenShiftAPIServerBuilder(openShiftAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig() {
    return new ConsoleSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item) {
    return new ConsoleSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl(item);
  }
  public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (authenticationObservedConfig!=null){ this.observedConfig= new AuthenticationBuilder(authenticationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public ConsoleSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig() {
    return new ConsoleSpecFluentImpl.AuthenticationObservedConfigNestedImpl();
  }
  public ConsoleSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item) {
    return new ConsoleSpecFluentImpl.AuthenticationObservedConfigNestedImpl(item);
  }
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel=operatorLogLevel; return (A) this;
  }
  public Boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  public A addToPlugins(Integer index,String item) {
    if (this.plugins == null) {this.plugins = new ArrayList<String>();}
    this.plugins.add(index, item);
    return (A)this;
  }
  public A setToPlugins(Integer index,String item) {
    if (this.plugins == null) {this.plugins = new ArrayList<String>();}
    this.plugins.set(index, item); return (A)this;
  }
  public A addToPlugins(java.lang.String... items) {
    if (this.plugins == null) {this.plugins = new ArrayList<String>();}
    for (String item : items) {this.plugins.add(item);} return (A)this;
  }
  public A addAllToPlugins(Collection<String> items) {
    if (this.plugins == null) {this.plugins = new ArrayList<String>();}
    for (String item : items) {this.plugins.add(item);} return (A)this;
  }
  public A removeFromPlugins(java.lang.String... items) {
    for (String item : items) {if (this.plugins!= null){ this.plugins.remove(item);}} return (A)this;
  }
  public A removeAllFromPlugins(Collection<String> items) {
    for (String item : items) {if (this.plugins!= null){ this.plugins.remove(item);}} return (A)this;
  }
  public List<String> getPlugins() {
    return this.plugins;
  }
  public String getPlugin(Integer index) {
    return this.plugins.get(index);
  }
  public String getFirstPlugin() {
    return this.plugins.get(0);
  }
  public String getLastPlugin() {
    return this.plugins.get(plugins.size() - 1);
  }
  public String getMatchingPlugin(Predicate<String> predicate) {
    for (String item: plugins) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPlugin(Predicate<String> predicate) {
    for (String item: plugins) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPlugins(List<String> plugins) {
    if (plugins != null) {this.plugins = new ArrayList(); for (String item : plugins){this.addToPlugins(item);}} else { this.plugins = null;} return (A) this;
  }
  public A withPlugins(java.lang.String... plugins) {
    if (this.plugins != null) {this.plugins.clear();}
    if (plugins != null) {for (String item :plugins){ this.addToPlugins(item);}} return (A) this;
  }
  public Boolean hasPlugins() {
    return plugins != null && !plugins.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildProviders instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConsoleProviders getProviders() {
    return this.providers!=null ?this.providers.build():null;
  }
  public ConsoleProviders buildProviders() {
    return this.providers!=null ?this.providers.build():null;
  }
  public A withProviders(ConsoleProviders providers) {
    _visitables.get("providers").remove(this.providers);
    if (providers!=null){ this.providers= new ConsoleProvidersBuilder(providers); _visitables.get("providers").add(this.providers);} else { this.providers = null; _visitables.get("providers").remove(this.providers); } return (A) this;
  }
  public Boolean hasProviders() {
    return this.providers != null;
  }
  public ConsoleSpecFluent.ProvidersNested<A> withNewProviders() {
    return new ConsoleSpecFluentImpl.ProvidersNestedImpl();
  }
  public ConsoleSpecFluent.ProvidersNested<A> withNewProvidersLike(ConsoleProviders item) {
    return new ConsoleSpecFluentImpl.ProvidersNestedImpl(item);
  }
  public ConsoleSpecFluent.ProvidersNested<A> editProviders() {
    return withNewProvidersLike(getProviders());
  }
  public ConsoleSpecFluent.ProvidersNested<A> editOrNewProviders() {
    return withNewProvidersLike(getProviders() != null ? getProviders(): new ConsoleProvidersBuilder().build());
  }
  public ConsoleSpecFluent.ProvidersNested<A> editOrNewProvidersLike(ConsoleProviders item) {
    return withNewProvidersLike(getProviders() != null ? getProviders(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRoute instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConsoleConfigRoute getRoute() {
    return this.route!=null ?this.route.build():null;
  }
  public ConsoleConfigRoute buildRoute() {
    return this.route!=null ?this.route.build():null;
  }
  public A withRoute(ConsoleConfigRoute route) {
    _visitables.get("route").remove(this.route);
    if (route!=null){ this.route= new ConsoleConfigRouteBuilder(route); _visitables.get("route").add(this.route);} else { this.route = null; _visitables.get("route").remove(this.route); } return (A) this;
  }
  public Boolean hasRoute() {
    return this.route != null;
  }
  public ConsoleSpecFluent.RouteNested<A> withNewRoute() {
    return new ConsoleSpecFluentImpl.RouteNestedImpl();
  }
  public ConsoleSpecFluent.RouteNested<A> withNewRouteLike(ConsoleConfigRoute item) {
    return new ConsoleSpecFluentImpl.RouteNestedImpl(item);
  }
  public ConsoleSpecFluent.RouteNested<A> editRoute() {
    return withNewRouteLike(getRoute());
  }
  public ConsoleSpecFluent.RouteNested<A> editOrNewRoute() {
    return withNewRouteLike(getRoute() != null ? getRoute(): new ConsoleConfigRouteBuilder().build());
  }
  public ConsoleSpecFluent.RouteNested<A> editOrNewRouteLike(ConsoleConfigRoute item) {
    return withNewRouteLike(getRoute() != null ? getRoute(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public HasMetadata buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides instanceof ImagePruner){ this.unsupportedConfigOverrides= new ImagePrunerBuilder((ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManager){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder((KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Storage){ this.unsupportedConfigOverrides= new StorageBuilder((Storage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCA){ this.unsupportedConfigOverrides= new ServiceCABuilder((ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Config){ this.unsupportedConfigOverrides= new ConfigBuilder((Config)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PersistentVolumeClaim){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServer){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder((KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressController){ this.unsupportedConfigOverrides= new IngressControllerBuilder((IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Console){ this.unsupportedConfigOverrides= new ConsoleBuilder((Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriver){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder((ClusterCSIDriver)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManager){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Etcd){ this.unsupportedConfigOverrides= new EtcdBuilder((Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredential){ this.unsupportedConfigOverrides= new CloudCredentialBuilder((CloudCredential)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeScheduler){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder((KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Network){ this.unsupportedConfigOverrides= new NetworkBuilder((Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheck){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotController){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder((CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNS){ this.unsupportedConfigOverrides= new DNSBuilder((DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecord){ this.unsupportedConfigOverrides= new DNSRecordBuilder((DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServer){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Authentication){ this.unsupportedConfigOverrides= new AuthenticationBuilder((Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    return (A) this;
  }
  public Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
    return new ConsoleSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
    return new ConsoleSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageUnsupportedConfigOverrides(Storage storageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageBuilder(storageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item) {
    return new ConsoleSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
    return new ConsoleSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
    return new ConsoleSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigUnsupportedConfigOverrides(Config configUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigBuilder(configUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item) {
    return new ConsoleSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
    return new ConsoleSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
    return new ConsoleSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
    return new ConsoleSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
    return new ConsoleSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
    return new ConsoleSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverUnsupportedConfigOverrides(ClusterCSIDriver clusterCSIDriverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder(clusterCSIDriverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item) {
    return new ConsoleSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
    return new ConsoleSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
    return new ConsoleSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCloudCredentialUnsupportedConfigOverrides(CloudCredential cloudCredentialUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialBuilder(cloudCredentialUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item) {
    return new ConsoleSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
    return new ConsoleSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
    return new ConsoleSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
    return new ConsoleSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckUnsupportedConfigOverrides(PodNetworkConnectivityCheck podNetworkConnectivityCheckUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item) {
    return new ConsoleSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
    return new ConsoleSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
    return new ConsoleSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
    return new ConsoleSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
    return new ConsoleSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
    return new ConsoleSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public ConsoleSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new ConsoleSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl();
  }
  public ConsoleSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
    return new ConsoleSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsoleSpecFluentImpl that = (ConsoleSpecFluentImpl) o;
    if (customization != null ? !customization.equals(that.customization) :that.customization != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
    if (observedConfig != null ? !observedConfig.equals(that.observedConfig) :that.observedConfig != null) return false;
    if (operatorLogLevel != null ? !operatorLogLevel.equals(that.operatorLogLevel) :that.operatorLogLevel != null) return false;
    if (plugins != null ? !plugins.equals(that.plugins) :that.plugins != null) return false;
    if (providers != null ? !providers.equals(that.providers) :that.providers != null) return false;
    if (route != null ? !route.equals(that.route) :that.route != null) return false;
    if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(customization,  logLevel,  managementState,  observedConfig,  operatorLogLevel,  plugins,  providers,  route,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (customization != null) { sb.append("customization:"); sb.append(customization + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (observedConfig != null) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (plugins != null && !plugins.isEmpty()) { sb.append("plugins:"); sb.append(plugins + ","); }
    if (providers != null) { sb.append("providers:"); sb.append(providers + ","); }
    if (route != null) { sb.append("route:"); sb.append(route + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CustomizationNestedImpl<N> extends ConsoleCustomizationFluentImpl<ConsoleSpecFluent.CustomizationNested<N>> implements ConsoleSpecFluent.CustomizationNested<N>,Nested<N>{
    CustomizationNestedImpl(ConsoleCustomization item) {
      this.builder = new ConsoleCustomizationBuilder(this, item);
    }
    CustomizationNestedImpl() {
      this.builder = new ConsoleCustomizationBuilder(this);
    }
    ConsoleCustomizationBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withCustomization(builder.build());
    }
    public N endCustomization() {
      return and();
    }
    
  }
  class ImagePrunerObservedConfigNestedImpl<N> extends ImagePrunerFluentImpl<ConsoleSpecFluent.ImagePrunerObservedConfigNested<N>> implements ConsoleSpecFluent.ImagePrunerObservedConfigNested<N>,Nested<N>{
    ImagePrunerObservedConfigNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerObservedConfigNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImagePrunerObservedConfig() {
      return and();
    }
    
  }
  class KubeControllerManagerObservedConfigNestedImpl<N> extends KubeControllerManagerFluentImpl<ConsoleSpecFluent.KubeControllerManagerObservedConfigNested<N>> implements ConsoleSpecFluent.KubeControllerManagerObservedConfigNested<N>,Nested<N>{
    KubeControllerManagerObservedConfigNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerObservedConfigNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class StorageObservedConfigNestedImpl<N> extends StorageFluentImpl<ConsoleSpecFluent.StorageObservedConfigNested<N>> implements ConsoleSpecFluent.StorageObservedConfigNested<N>,Nested<N>{
    StorageObservedConfigNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageObservedConfigNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStorageObservedConfig() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyObservedConfigNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<ConsoleSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> implements ConsoleSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>,Nested<N>{
    ImageContentSourcePolicyObservedConfigNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyObservedConfigNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImageContentSourcePolicyObservedConfig() {
      return and();
    }
    
  }
  class ServiceCAObservedConfigNestedImpl<N> extends ServiceCAFluentImpl<ConsoleSpecFluent.ServiceCAObservedConfigNested<N>> implements ConsoleSpecFluent.ServiceCAObservedConfigNested<N>,Nested<N>{
    ServiceCAObservedConfigNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAObservedConfigNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCAObservedConfig() {
      return and();
    }
    
  }
  class ConfigObservedConfigNestedImpl<N> extends ConfigFluentImpl<ConsoleSpecFluent.ConfigObservedConfigNested<N>> implements ConsoleSpecFluent.ConfigObservedConfigNested<N>,Nested<N>{
    ConfigObservedConfigNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigObservedConfigNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConfigObservedConfig() {
      return and();
    }
    
  }
  class PersistentVolumeClaimObservedConfigNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ConsoleSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> implements ConsoleSpecFluent.PersistentVolumeClaimObservedConfigNested<N>,Nested<N>{
    PersistentVolumeClaimObservedConfigNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimObservedConfigNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPersistentVolumeClaimObservedConfig() {
      return and();
    }
    
  }
  class KubeAPIServerObservedConfigNestedImpl<N> extends KubeAPIServerFluentImpl<ConsoleSpecFluent.KubeAPIServerObservedConfigNested<N>> implements ConsoleSpecFluent.KubeAPIServerObservedConfigNested<N>,Nested<N>{
    KubeAPIServerObservedConfigNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerObservedConfigNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeAPIServerObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerObservedConfigNestedImpl<N> extends IngressControllerFluentImpl<ConsoleSpecFluent.IngressControllerObservedConfigNested<N>> implements ConsoleSpecFluent.IngressControllerObservedConfigNested<N>,Nested<N>{
    IngressControllerObservedConfigNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerObservedConfigNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerObservedConfig() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorObservedConfigNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<ConsoleSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> implements ConsoleSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>,Nested<N>{
    KubeStorageVersionMigratorObservedConfigNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorObservedConfigNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeStorageVersionMigratorObservedConfig() {
      return and();
    }
    
  }
  class ConsoleObservedConfigNestedImpl<N> extends ConsoleFluentImpl<ConsoleSpecFluent.ConsoleObservedConfigNested<N>> implements ConsoleSpecFluent.ConsoleObservedConfigNested<N>,Nested<N>{
    ConsoleObservedConfigNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleObservedConfigNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleObservedConfig() {
      return and();
    }
    
  }
  class ClusterCSIDriverObservedConfigNestedImpl<N> extends ClusterCSIDriverFluentImpl<ConsoleSpecFluent.ClusterCSIDriverObservedConfigNested<N>> implements ConsoleSpecFluent.ClusterCSIDriverObservedConfigNested<N>,Nested<N>{
    ClusterCSIDriverObservedConfigNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverObservedConfigNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterCSIDriverObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerObservedConfigNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<ConsoleSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> implements ConsoleSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>,Nested<N>{
    OpenShiftControllerManagerObservedConfigNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerObservedConfigNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class EtcdObservedConfigNestedImpl<N> extends EtcdFluentImpl<ConsoleSpecFluent.EtcdObservedConfigNested<N>> implements ConsoleSpecFluent.EtcdObservedConfigNested<N>,Nested<N>{
    EtcdObservedConfigNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdObservedConfigNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEtcdObservedConfig() {
      return and();
    }
    
  }
  class CloudCredentialObservedConfigNestedImpl<N> extends CloudCredentialFluentImpl<ConsoleSpecFluent.CloudCredentialObservedConfigNested<N>> implements ConsoleSpecFluent.CloudCredentialObservedConfigNested<N>,Nested<N>{
    CloudCredentialObservedConfigNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialObservedConfigNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCloudCredentialObservedConfig() {
      return and();
    }
    
  }
  class KubeSchedulerObservedConfigNestedImpl<N> extends KubeSchedulerFluentImpl<ConsoleSpecFluent.KubeSchedulerObservedConfigNested<N>> implements ConsoleSpecFluent.KubeSchedulerObservedConfigNested<N>,Nested<N>{
    KubeSchedulerObservedConfigNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerObservedConfigNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeSchedulerObservedConfig() {
      return and();
    }
    
  }
  class NetworkObservedConfigNestedImpl<N> extends NetworkFluentImpl<ConsoleSpecFluent.NetworkObservedConfigNested<N>> implements ConsoleSpecFluent.NetworkObservedConfigNested<N>,Nested<N>{
    NetworkObservedConfigNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkObservedConfigNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerObservedConfigNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<ConsoleSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> implements ConsoleSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogAPIServerObservedConfigNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogAPIServerObservedConfig() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckObservedConfigNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<ConsoleSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>> implements ConsoleSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>,Nested<N>{
    PodNetworkConnectivityCheckObservedConfigNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckObservedConfigNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckObservedConfig() {
      return and();
    }
    
  }
  class CSISnapshotControllerObservedConfigNestedImpl<N> extends CSISnapshotControllerFluentImpl<ConsoleSpecFluent.CSISnapshotControllerObservedConfigNested<N>> implements ConsoleSpecFluent.CSISnapshotControllerObservedConfigNested<N>,Nested<N>{
    CSISnapshotControllerObservedConfigNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerObservedConfigNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCSISnapshotControllerObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerObservedConfigNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<ConsoleSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> implements ConsoleSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogControllerManagerObservedConfigNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class DNSObservedConfigNestedImpl<N> extends DNSFluentImpl<ConsoleSpecFluent.DNSObservedConfigNested<N>> implements ConsoleSpecFluent.DNSObservedConfigNested<N>,Nested<N>{
    DNSObservedConfigNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSObservedConfigNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSObservedConfig() {
      return and();
    }
    
  }
  class DNSRecordObservedConfigNestedImpl<N> extends DNSRecordFluentImpl<ConsoleSpecFluent.DNSRecordObservedConfigNested<N>> implements ConsoleSpecFluent.DNSRecordObservedConfigNested<N>,Nested<N>{
    DNSRecordObservedConfigNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordObservedConfigNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSRecordObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftAPIServerObservedConfigNestedImpl<N> extends OpenShiftAPIServerFluentImpl<ConsoleSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> implements ConsoleSpecFluent.OpenShiftAPIServerObservedConfigNested<N>,Nested<N>{
    OpenShiftAPIServerObservedConfigNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerObservedConfigNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftAPIServerObservedConfig() {
      return and();
    }
    
  }
  class AuthenticationObservedConfigNestedImpl<N> extends AuthenticationFluentImpl<ConsoleSpecFluent.AuthenticationObservedConfigNested<N>> implements ConsoleSpecFluent.AuthenticationObservedConfigNested<N>,Nested<N>{
    AuthenticationObservedConfigNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationObservedConfigNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAuthenticationObservedConfig() {
      return and();
    }
    
  }
  class ProvidersNestedImpl<N> extends ConsoleProvidersFluentImpl<ConsoleSpecFluent.ProvidersNested<N>> implements ConsoleSpecFluent.ProvidersNested<N>,Nested<N>{
    ProvidersNestedImpl(ConsoleProviders item) {
      this.builder = new ConsoleProvidersBuilder(this, item);
    }
    ProvidersNestedImpl() {
      this.builder = new ConsoleProvidersBuilder(this);
    }
    ConsoleProvidersBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withProviders(builder.build());
    }
    public N endProviders() {
      return and();
    }
    
  }
  class RouteNestedImpl<N> extends ConsoleConfigRouteFluentImpl<ConsoleSpecFluent.RouteNested<N>> implements ConsoleSpecFluent.RouteNested<N>,Nested<N>{
    RouteNestedImpl(ConsoleConfigRoute item) {
      this.builder = new ConsoleConfigRouteBuilder(this, item);
    }
    RouteNestedImpl() {
      this.builder = new ConsoleConfigRouteBuilder(this);
    }
    ConsoleConfigRouteBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withRoute(builder.build());
    }
    public N endRoute() {
      return and();
    }
    
  }
  class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerFluentImpl<ConsoleSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerFluentImpl<ConsoleSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageUnsupportedConfigOverridesNestedImpl<N> extends StorageFluentImpl<ConsoleSpecFluent.StorageUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.StorageUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageUnsupportedConfigOverridesNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<ConsoleSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAFluentImpl<ConsoleSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAUnsupportedConfigOverridesNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigUnsupportedConfigOverridesNestedImpl<N> extends ConfigFluentImpl<ConsoleSpecFluent.ConfigUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.ConfigUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigUnsupportedConfigOverridesNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ConsoleSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerFluentImpl<ConsoleSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerFluentImpl<ConsoleSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerUnsupportedConfigOverridesNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<ConsoleSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends ConsoleFluentImpl<ConsoleSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleUnsupportedConfigOverridesNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverFluentImpl<ConsoleSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<ConsoleSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdUnsupportedConfigOverridesNestedImpl<N> extends EtcdFluentImpl<ConsoleSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdUnsupportedConfigOverridesNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CloudCredentialUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialFluentImpl<ConsoleSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerFluentImpl<ConsoleSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkUnsupportedConfigOverridesNestedImpl<N> extends NetworkFluentImpl<ConsoleSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkUnsupportedConfigOverridesNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<ConsoleSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<ConsoleSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerFluentImpl<ConsoleSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<ConsoleSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSUnsupportedConfigOverridesNestedImpl<N> extends DNSFluentImpl<ConsoleSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.DNSUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSUnsupportedConfigOverridesNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordFluentImpl<ConsoleSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordUnsupportedConfigOverridesNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerFluentImpl<ConsoleSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationFluentImpl<ConsoleSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements ConsoleSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationUnsupportedConfigOverridesNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  
}