package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CloudCredentialSpecFluentImpl<A extends CloudCredentialSpecFluent<A>> extends BaseFluent<A> implements CloudCredentialSpecFluent<A>{
  public CloudCredentialSpecFluentImpl() {
  }
  public CloudCredentialSpecFluentImpl(CloudCredentialSpec instance) {
    this.withCredentialsMode(instance.getCredentialsMode()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String credentialsMode;
  private String logLevel;
  private String managementState;
  private VisitableBuilder<? extends HasMetadata,?> observedConfig;
  private String operatorLogLevel;
  private VisitableBuilder<? extends HasMetadata,?> unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  public String getCredentialsMode() {
    return this.credentialsMode;
  }
  public A withCredentialsMode(String credentialsMode) {
    this.credentialsMode=credentialsMode; return (A) this;
  }
  public Boolean hasCredentialsMode() {
    return this.credentialsMode != null;
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public Boolean hasManagementState() {
    return this.managementState != null;
  }
  
  /**
   * This method has been deprecated, please use method buildObservedConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public HasMetadata buildObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public A withObservedConfig(HasMetadata observedConfig) {
    if (observedConfig instanceof ImagePruner){ this.observedConfig= new ImagePrunerBuilder((ImagePruner)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeControllerManager){ this.observedConfig= new KubeControllerManagerBuilder((KubeControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Storage){ this.observedConfig= new StorageBuilder((Storage)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImageContentSourcePolicy){ this.observedConfig= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCA){ this.observedConfig= new ServiceCABuilder((ServiceCA)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Config){ this.observedConfig= new ConfigBuilder((Config)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PersistentVolumeClaim){ this.observedConfig= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeAPIServer){ this.observedConfig= new KubeAPIServerBuilder((KubeAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressController){ this.observedConfig= new IngressControllerBuilder((IngressController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeStorageVersionMigrator){ this.observedConfig= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Console){ this.observedConfig= new ConsoleBuilder((Console)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClusterCSIDriver){ this.observedConfig= new ClusterCSIDriverBuilder((ClusterCSIDriver)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftControllerManager){ this.observedConfig= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Etcd){ this.observedConfig= new EtcdBuilder((Etcd)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CloudCredential){ this.observedConfig= new CloudCredentialBuilder((CloudCredential)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeScheduler){ this.observedConfig= new KubeSchedulerBuilder((KubeScheduler)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Network){ this.observedConfig= new NetworkBuilder((Network)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogAPIServer){ this.observedConfig= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodNetworkConnectivityCheck){ this.observedConfig= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CSISnapshotController){ this.observedConfig= new CSISnapshotControllerBuilder((CSISnapshotController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogControllerManager){ this.observedConfig= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNS){ this.observedConfig= new DNSBuilder((DNS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSRecord){ this.observedConfig= new DNSRecordBuilder((DNSRecord)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftAPIServer){ this.observedConfig= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Authentication){ this.observedConfig= new AuthenticationBuilder((Authentication)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    return (A) this;
  }
  public Boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imagePrunerObservedConfig!=null){ this.observedConfig= new ImagePrunerBuilder(imagePrunerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.ImagePrunerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item) {
    return new CloudCredentialSpecFluentImpl.ImagePrunerObservedConfigNestedImpl(item);
  }
  public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeControllerManagerObservedConfig!=null){ this.observedConfig= new KubeControllerManagerBuilder(kubeControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item) {
    return new CloudCredentialSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl(item);
  }
  public A withStorageObservedConfig(Storage storageObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (storageObservedConfig!=null){ this.observedConfig= new StorageBuilder(storageObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfig() {
    return new CloudCredentialSpecFluentImpl.StorageObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfigLike(Storage item) {
    return new CloudCredentialSpecFluentImpl.StorageObservedConfigNestedImpl(item);
  }
  public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imageContentSourcePolicyObservedConfig!=null){ this.observedConfig= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig() {
    return new CloudCredentialSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item) {
    return new CloudCredentialSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl(item);
  }
  public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCAObservedConfig!=null){ this.observedConfig= new ServiceCABuilder(serviceCAObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig() {
    return new CloudCredentialSpecFluentImpl.ServiceCAObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item) {
    return new CloudCredentialSpecFluentImpl.ServiceCAObservedConfigNestedImpl(item);
  }
  public A withConfigObservedConfig(Config configObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (configObservedConfig!=null){ this.observedConfig= new ConfigBuilder(configObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfig() {
    return new CloudCredentialSpecFluentImpl.ConfigObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfigLike(Config item) {
    return new CloudCredentialSpecFluentImpl.ConfigObservedConfigNestedImpl(item);
  }
  public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (persistentVolumeClaimObservedConfig!=null){ this.observedConfig= new PersistentVolumeClaimBuilder(persistentVolumeClaimObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig() {
    return new CloudCredentialSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item) {
    return new CloudCredentialSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl(item);
  }
  public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeAPIServerObservedConfig!=null){ this.observedConfig= new KubeAPIServerBuilder(kubeAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item) {
    return new CloudCredentialSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl(item);
  }
  public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerObservedConfig!=null){ this.observedConfig= new IngressControllerBuilder(ingressControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.IngressControllerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item) {
    return new CloudCredentialSpecFluentImpl.IngressControllerObservedConfigNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeStorageVersionMigratorObservedConfig!=null){ this.observedConfig= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig() {
    return new CloudCredentialSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item) {
    return new CloudCredentialSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl(item);
  }
  public A withConsoleObservedConfig(Console consoleObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleObservedConfig!=null){ this.observedConfig= new ConsoleBuilder(consoleObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig() {
    return new CloudCredentialSpecFluentImpl.ConsoleObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item) {
    return new CloudCredentialSpecFluentImpl.ConsoleObservedConfigNestedImpl(item);
  }
  public A withClusterCSIDriverObservedConfig(ClusterCSIDriver clusterCSIDriverObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterCSIDriverObservedConfig!=null){ this.observedConfig= new ClusterCSIDriverBuilder(clusterCSIDriverObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfig() {
    return new CloudCredentialSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfigLike(ClusterCSIDriver item) {
    return new CloudCredentialSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl(item);
  }
  public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftControllerManagerObservedConfig!=null){ this.observedConfig= new OpenShiftControllerManagerBuilder(openShiftControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item) {
    return new CloudCredentialSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl(item);
  }
  public A withEtcdObservedConfig(Etcd etcdObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (etcdObservedConfig!=null){ this.observedConfig= new EtcdBuilder(etcdObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig() {
    return new CloudCredentialSpecFluentImpl.EtcdObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item) {
    return new CloudCredentialSpecFluentImpl.EtcdObservedConfigNestedImpl(item);
  }
  public A withCloudCredentialObservedConfig(CloudCredential cloudCredentialObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cloudCredentialObservedConfig!=null){ this.observedConfig= new CloudCredentialBuilder(cloudCredentialObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfig() {
    return new CloudCredentialSpecFluentImpl.CloudCredentialObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfigLike(CloudCredential item) {
    return new CloudCredentialSpecFluentImpl.CloudCredentialObservedConfigNestedImpl(item);
  }
  public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeSchedulerObservedConfig!=null){ this.observedConfig= new KubeSchedulerBuilder(kubeSchedulerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item) {
    return new CloudCredentialSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl(item);
  }
  public A withNetworkObservedConfig(Network networkObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkObservedConfig!=null){ this.observedConfig= new NetworkBuilder(networkObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig() {
    return new CloudCredentialSpecFluentImpl.NetworkObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item) {
    return new CloudCredentialSpecFluentImpl.NetworkObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogAPIServerObservedConfig!=null){ this.observedConfig= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item) {
    return new CloudCredentialSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckObservedConfig(PodNetworkConnectivityCheck podNetworkConnectivityCheckObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckObservedConfig!=null){ this.observedConfig= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfig() {
    return new CloudCredentialSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfigLike(PodNetworkConnectivityCheck item) {
    return new CloudCredentialSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl(item);
  }
  public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cSISnapshotControllerObservedConfig!=null){ this.observedConfig= new CSISnapshotControllerBuilder(cSISnapshotControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item) {
    return new CloudCredentialSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogControllerManagerObservedConfig!=null){ this.observedConfig= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item) {
    return new CloudCredentialSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl(item);
  }
  public A withDNSObservedConfig(DNS dNSObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSObservedConfig!=null){ this.observedConfig= new DNSBuilder(dNSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig() {
    return new CloudCredentialSpecFluentImpl.DNSObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item) {
    return new CloudCredentialSpecFluentImpl.DNSObservedConfigNestedImpl(item);
  }
  public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSRecordObservedConfig!=null){ this.observedConfig= new DNSRecordBuilder(dNSRecordObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig() {
    return new CloudCredentialSpecFluentImpl.DNSRecordObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item) {
    return new CloudCredentialSpecFluentImpl.DNSRecordObservedConfigNestedImpl(item);
  }
  public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftAPIServerObservedConfig!=null){ this.observedConfig= new OpenShiftAPIServerBuilder(openShiftAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig() {
    return new CloudCredentialSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item) {
    return new CloudCredentialSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl(item);
  }
  public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (authenticationObservedConfig!=null){ this.observedConfig= new AuthenticationBuilder(authenticationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public CloudCredentialSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig() {
    return new CloudCredentialSpecFluentImpl.AuthenticationObservedConfigNestedImpl();
  }
  public CloudCredentialSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item) {
    return new CloudCredentialSpecFluentImpl.AuthenticationObservedConfigNestedImpl(item);
  }
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel=operatorLogLevel; return (A) this;
  }
  public Boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public HasMetadata buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides instanceof ImagePruner){ this.unsupportedConfigOverrides= new ImagePrunerBuilder((ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManager){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder((KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Storage){ this.unsupportedConfigOverrides= new StorageBuilder((Storage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCA){ this.unsupportedConfigOverrides= new ServiceCABuilder((ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Config){ this.unsupportedConfigOverrides= new ConfigBuilder((Config)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PersistentVolumeClaim){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServer){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder((KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressController){ this.unsupportedConfigOverrides= new IngressControllerBuilder((IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Console){ this.unsupportedConfigOverrides= new ConsoleBuilder((Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriver){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder((ClusterCSIDriver)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManager){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Etcd){ this.unsupportedConfigOverrides= new EtcdBuilder((Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredential){ this.unsupportedConfigOverrides= new CloudCredentialBuilder((CloudCredential)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeScheduler){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder((KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Network){ this.unsupportedConfigOverrides= new NetworkBuilder((Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheck){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotController){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder((CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNS){ this.unsupportedConfigOverrides= new DNSBuilder((DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecord){ this.unsupportedConfigOverrides= new DNSRecordBuilder((DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServer){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Authentication){ this.unsupportedConfigOverrides= new AuthenticationBuilder((Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    return (A) this;
  }
  public Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
    return new CloudCredentialSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
    return new CloudCredentialSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageUnsupportedConfigOverrides(Storage storageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageBuilder(storageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item) {
    return new CloudCredentialSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
    return new CloudCredentialSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
    return new CloudCredentialSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigUnsupportedConfigOverrides(Config configUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigBuilder(configUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item) {
    return new CloudCredentialSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
    return new CloudCredentialSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
    return new CloudCredentialSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
    return new CloudCredentialSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
    return new CloudCredentialSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
    return new CloudCredentialSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverUnsupportedConfigOverrides(ClusterCSIDriver clusterCSIDriverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder(clusterCSIDriverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item) {
    return new CloudCredentialSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
    return new CloudCredentialSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
    return new CloudCredentialSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCloudCredentialUnsupportedConfigOverrides(CloudCredential cloudCredentialUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialBuilder(cloudCredentialUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item) {
    return new CloudCredentialSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
    return new CloudCredentialSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
    return new CloudCredentialSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
    return new CloudCredentialSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckUnsupportedConfigOverrides(PodNetworkConnectivityCheck podNetworkConnectivityCheckUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item) {
    return new CloudCredentialSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
    return new CloudCredentialSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
    return new CloudCredentialSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
    return new CloudCredentialSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
    return new CloudCredentialSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
    return new CloudCredentialSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public CloudCredentialSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new CloudCredentialSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl();
  }
  public CloudCredentialSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
    return new CloudCredentialSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CloudCredentialSpecFluentImpl that = (CloudCredentialSpecFluentImpl) o;
    if (credentialsMode != null ? !credentialsMode.equals(that.credentialsMode) :that.credentialsMode != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
    if (observedConfig != null ? !observedConfig.equals(that.observedConfig) :that.observedConfig != null) return false;
    if (operatorLogLevel != null ? !operatorLogLevel.equals(that.operatorLogLevel) :that.operatorLogLevel != null) return false;
    if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(credentialsMode,  logLevel,  managementState,  observedConfig,  operatorLogLevel,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (credentialsMode != null) { sb.append("credentialsMode:"); sb.append(credentialsMode + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (observedConfig != null) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImagePrunerObservedConfigNestedImpl<N> extends ImagePrunerFluentImpl<CloudCredentialSpecFluent.ImagePrunerObservedConfigNested<N>> implements CloudCredentialSpecFluent.ImagePrunerObservedConfigNested<N>,Nested<N>{
    ImagePrunerObservedConfigNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerObservedConfigNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImagePrunerObservedConfig() {
      return and();
    }
    
  }
  class KubeControllerManagerObservedConfigNestedImpl<N> extends KubeControllerManagerFluentImpl<CloudCredentialSpecFluent.KubeControllerManagerObservedConfigNested<N>> implements CloudCredentialSpecFluent.KubeControllerManagerObservedConfigNested<N>,Nested<N>{
    KubeControllerManagerObservedConfigNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerObservedConfigNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class StorageObservedConfigNestedImpl<N> extends StorageFluentImpl<CloudCredentialSpecFluent.StorageObservedConfigNested<N>> implements CloudCredentialSpecFluent.StorageObservedConfigNested<N>,Nested<N>{
    StorageObservedConfigNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageObservedConfigNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStorageObservedConfig() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyObservedConfigNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<CloudCredentialSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> implements CloudCredentialSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>,Nested<N>{
    ImageContentSourcePolicyObservedConfigNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyObservedConfigNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImageContentSourcePolicyObservedConfig() {
      return and();
    }
    
  }
  class ServiceCAObservedConfigNestedImpl<N> extends ServiceCAFluentImpl<CloudCredentialSpecFluent.ServiceCAObservedConfigNested<N>> implements CloudCredentialSpecFluent.ServiceCAObservedConfigNested<N>,Nested<N>{
    ServiceCAObservedConfigNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAObservedConfigNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCAObservedConfig() {
      return and();
    }
    
  }
  class ConfigObservedConfigNestedImpl<N> extends ConfigFluentImpl<CloudCredentialSpecFluent.ConfigObservedConfigNested<N>> implements CloudCredentialSpecFluent.ConfigObservedConfigNested<N>,Nested<N>{
    ConfigObservedConfigNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigObservedConfigNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConfigObservedConfig() {
      return and();
    }
    
  }
  class PersistentVolumeClaimObservedConfigNestedImpl<N> extends PersistentVolumeClaimFluentImpl<CloudCredentialSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> implements CloudCredentialSpecFluent.PersistentVolumeClaimObservedConfigNested<N>,Nested<N>{
    PersistentVolumeClaimObservedConfigNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimObservedConfigNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPersistentVolumeClaimObservedConfig() {
      return and();
    }
    
  }
  class KubeAPIServerObservedConfigNestedImpl<N> extends KubeAPIServerFluentImpl<CloudCredentialSpecFluent.KubeAPIServerObservedConfigNested<N>> implements CloudCredentialSpecFluent.KubeAPIServerObservedConfigNested<N>,Nested<N>{
    KubeAPIServerObservedConfigNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerObservedConfigNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeAPIServerObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerObservedConfigNestedImpl<N> extends IngressControllerFluentImpl<CloudCredentialSpecFluent.IngressControllerObservedConfigNested<N>> implements CloudCredentialSpecFluent.IngressControllerObservedConfigNested<N>,Nested<N>{
    IngressControllerObservedConfigNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerObservedConfigNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerObservedConfig() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorObservedConfigNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<CloudCredentialSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> implements CloudCredentialSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>,Nested<N>{
    KubeStorageVersionMigratorObservedConfigNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorObservedConfigNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeStorageVersionMigratorObservedConfig() {
      return and();
    }
    
  }
  class ConsoleObservedConfigNestedImpl<N> extends ConsoleFluentImpl<CloudCredentialSpecFluent.ConsoleObservedConfigNested<N>> implements CloudCredentialSpecFluent.ConsoleObservedConfigNested<N>,Nested<N>{
    ConsoleObservedConfigNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleObservedConfigNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleObservedConfig() {
      return and();
    }
    
  }
  class ClusterCSIDriverObservedConfigNestedImpl<N> extends ClusterCSIDriverFluentImpl<CloudCredentialSpecFluent.ClusterCSIDriverObservedConfigNested<N>> implements CloudCredentialSpecFluent.ClusterCSIDriverObservedConfigNested<N>,Nested<N>{
    ClusterCSIDriverObservedConfigNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverObservedConfigNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterCSIDriverObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerObservedConfigNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<CloudCredentialSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> implements CloudCredentialSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>,Nested<N>{
    OpenShiftControllerManagerObservedConfigNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerObservedConfigNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class EtcdObservedConfigNestedImpl<N> extends EtcdFluentImpl<CloudCredentialSpecFluent.EtcdObservedConfigNested<N>> implements CloudCredentialSpecFluent.EtcdObservedConfigNested<N>,Nested<N>{
    EtcdObservedConfigNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdObservedConfigNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEtcdObservedConfig() {
      return and();
    }
    
  }
  class CloudCredentialObservedConfigNestedImpl<N> extends CloudCredentialFluentImpl<CloudCredentialSpecFluent.CloudCredentialObservedConfigNested<N>> implements CloudCredentialSpecFluent.CloudCredentialObservedConfigNested<N>,Nested<N>{
    CloudCredentialObservedConfigNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialObservedConfigNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCloudCredentialObservedConfig() {
      return and();
    }
    
  }
  class KubeSchedulerObservedConfigNestedImpl<N> extends KubeSchedulerFluentImpl<CloudCredentialSpecFluent.KubeSchedulerObservedConfigNested<N>> implements CloudCredentialSpecFluent.KubeSchedulerObservedConfigNested<N>,Nested<N>{
    KubeSchedulerObservedConfigNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerObservedConfigNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeSchedulerObservedConfig() {
      return and();
    }
    
  }
  class NetworkObservedConfigNestedImpl<N> extends NetworkFluentImpl<CloudCredentialSpecFluent.NetworkObservedConfigNested<N>> implements CloudCredentialSpecFluent.NetworkObservedConfigNested<N>,Nested<N>{
    NetworkObservedConfigNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkObservedConfigNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerObservedConfigNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<CloudCredentialSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> implements CloudCredentialSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogAPIServerObservedConfigNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogAPIServerObservedConfig() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckObservedConfigNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<CloudCredentialSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>> implements CloudCredentialSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>,Nested<N>{
    PodNetworkConnectivityCheckObservedConfigNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckObservedConfigNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckObservedConfig() {
      return and();
    }
    
  }
  class CSISnapshotControllerObservedConfigNestedImpl<N> extends CSISnapshotControllerFluentImpl<CloudCredentialSpecFluent.CSISnapshotControllerObservedConfigNested<N>> implements CloudCredentialSpecFluent.CSISnapshotControllerObservedConfigNested<N>,Nested<N>{
    CSISnapshotControllerObservedConfigNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerObservedConfigNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCSISnapshotControllerObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerObservedConfigNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<CloudCredentialSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> implements CloudCredentialSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogControllerManagerObservedConfigNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class DNSObservedConfigNestedImpl<N> extends DNSFluentImpl<CloudCredentialSpecFluent.DNSObservedConfigNested<N>> implements CloudCredentialSpecFluent.DNSObservedConfigNested<N>,Nested<N>{
    DNSObservedConfigNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSObservedConfigNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSObservedConfig() {
      return and();
    }
    
  }
  class DNSRecordObservedConfigNestedImpl<N> extends DNSRecordFluentImpl<CloudCredentialSpecFluent.DNSRecordObservedConfigNested<N>> implements CloudCredentialSpecFluent.DNSRecordObservedConfigNested<N>,Nested<N>{
    DNSRecordObservedConfigNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordObservedConfigNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSRecordObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftAPIServerObservedConfigNestedImpl<N> extends OpenShiftAPIServerFluentImpl<CloudCredentialSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> implements CloudCredentialSpecFluent.OpenShiftAPIServerObservedConfigNested<N>,Nested<N>{
    OpenShiftAPIServerObservedConfigNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerObservedConfigNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftAPIServerObservedConfig() {
      return and();
    }
    
  }
  class AuthenticationObservedConfigNestedImpl<N> extends AuthenticationFluentImpl<CloudCredentialSpecFluent.AuthenticationObservedConfigNested<N>> implements CloudCredentialSpecFluent.AuthenticationObservedConfigNested<N>,Nested<N>{
    AuthenticationObservedConfigNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationObservedConfigNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAuthenticationObservedConfig() {
      return and();
    }
    
  }
  class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerFluentImpl<CloudCredentialSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerFluentImpl<CloudCredentialSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageUnsupportedConfigOverridesNestedImpl<N> extends StorageFluentImpl<CloudCredentialSpecFluent.StorageUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.StorageUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageUnsupportedConfigOverridesNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<CloudCredentialSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAFluentImpl<CloudCredentialSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAUnsupportedConfigOverridesNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigUnsupportedConfigOverridesNestedImpl<N> extends ConfigFluentImpl<CloudCredentialSpecFluent.ConfigUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.ConfigUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigUnsupportedConfigOverridesNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<CloudCredentialSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerFluentImpl<CloudCredentialSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerFluentImpl<CloudCredentialSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerUnsupportedConfigOverridesNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<CloudCredentialSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends ConsoleFluentImpl<CloudCredentialSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleUnsupportedConfigOverridesNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverFluentImpl<CloudCredentialSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<CloudCredentialSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdUnsupportedConfigOverridesNestedImpl<N> extends EtcdFluentImpl<CloudCredentialSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdUnsupportedConfigOverridesNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CloudCredentialUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialFluentImpl<CloudCredentialSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerFluentImpl<CloudCredentialSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkUnsupportedConfigOverridesNestedImpl<N> extends NetworkFluentImpl<CloudCredentialSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkUnsupportedConfigOverridesNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<CloudCredentialSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<CloudCredentialSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerFluentImpl<CloudCredentialSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<CloudCredentialSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSUnsupportedConfigOverridesNestedImpl<N> extends DNSFluentImpl<CloudCredentialSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.DNSUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSUnsupportedConfigOverridesNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordFluentImpl<CloudCredentialSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordUnsupportedConfigOverridesNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerFluentImpl<CloudCredentialSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationFluentImpl<CloudCredentialSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements CloudCredentialSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationUnsupportedConfigOverridesNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) CloudCredentialSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  
}