package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.TLSProfileSpecFluentImpl;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.TLSProfileSpec;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.openshift.api.model.TLSProfileSpecBuilder;

 /**
  * Generated
  */
public class IngressControllerStatusFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent<A>{
  public IngressControllerStatusFluentImpl() {
  }
  public IngressControllerStatusFluentImpl(io.fabric8.openshift.api.model.operator.v1.IngressControllerStatus instance) {
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withConditions(instance.getConditions()); 
    this.withDomain(instance.getDomain()); 
    this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSelector(instance.getSelector()); 
    this.withTlsProfile(instance.getTlsProfile()); 
  }
  private java.lang.Integer availableReplicas;
  private java.util.List<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder>();
  private java.lang.String domain;
  private io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder endpointPublishingStrategy;
  private java.lang.Long observedGeneration;
  private java.lang.String selector;
  private io.fabric8.openshift.api.model.TLSProfileSpecBuilder tlsProfile;
  public java.lang.Integer getAvailableReplicas() {
    return this.availableReplicas;
  }
  public A withAvailableReplicas(java.lang.Integer availableReplicas) {
    this.availableReplicas=availableReplicas; return (A) this;
  }
  public java.lang.Boolean hasAvailableReplicas() {
    return this.availableReplicas != null;
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder>();}
    io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.OperatorCondition item : items) {io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.OperatorCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder>();}
    for (io.fabric8.openshift.api.model.operator.v1.OperatorCondition item : items) {io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    for (io.fabric8.openshift.api.model.operator.v1.OperatorCondition item : items) {io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.OperatorCondition> items) {
    for (io.fabric8.openshift.api.model.operator.v1.OperatorCondition item : items) {io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.OperatorCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.openshift.api.model.operator.v1.OperatorCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.openshift.api.model.operator.v1.OperatorCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.OperatorCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.OperatorCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.operator.v1.OperatorCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.openshift.api.model.operator.v1.OperatorCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder>(); for (io.fabric8.openshift.api.model.operator.v1.OperatorCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.openshift.api.model.operator.v1.OperatorCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.operator.v1.OperatorCondition item) {
    return new io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.OperatorCondition item) {
    return new io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.String getDomain() {
    return this.domain;
  }
  public A withDomain(java.lang.String domain) {
    this.domain=domain; return (A) this;
  }
  public java.lang.Boolean hasDomain() {
    return this.domain != null;
  }
  
  /**
   * Method is deprecated. use withDomain instead.
   */
  @java.lang.Deprecated
  public A withNewDomain(java.lang.String arg0) {
    return (A)withDomain(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointPublishingStrategy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy getEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy!=null?this.endpointPublishingStrategy.build():null;
  }
  public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy buildEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy!=null?this.endpointPublishingStrategy.build():null;
  }
  public A withEndpointPublishingStrategy(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy endpointPublishingStrategy) {
    _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
    if (endpointPublishingStrategy!=null){ this.endpointPublishingStrategy= new io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder(endpointPublishingStrategy); _visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);} return (A) this;
  }
  public java.lang.Boolean hasEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy != null;
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
    return new io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluentImpl.EndpointPublishingStrategyNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy item) {
    return new io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluentImpl.EndpointPublishingStrategyNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy());
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): new io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder().build());
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy item) {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): item);
  }
  public java.lang.Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(java.lang.Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public java.lang.Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public java.lang.String getSelector() {
    return this.selector;
  }
  public A withSelector(java.lang.String selector) {
    this.selector=selector; return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  
  /**
   * Method is deprecated. use withSelector instead.
   */
  @java.lang.Deprecated
  public A withNewSelector(java.lang.String arg0) {
    return (A)withSelector(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildTlsProfile instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.TLSProfileSpec getTlsProfile() {
    return this.tlsProfile!=null?this.tlsProfile.build():null;
  }
  public io.fabric8.openshift.api.model.TLSProfileSpec buildTlsProfile() {
    return this.tlsProfile!=null?this.tlsProfile.build():null;
  }
  public A withTlsProfile(io.fabric8.openshift.api.model.TLSProfileSpec tlsProfile) {
    _visitables.get("tlsProfile").remove(this.tlsProfile);
    if (tlsProfile!=null){ this.tlsProfile= new io.fabric8.openshift.api.model.TLSProfileSpecBuilder(tlsProfile); _visitables.get("tlsProfile").add(this.tlsProfile);} return (A) this;
  }
  public java.lang.Boolean hasTlsProfile() {
    return this.tlsProfile != null;
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> withNewTlsProfile() {
    return new io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluentImpl.TlsProfileNestedImpl();
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> withNewTlsProfileLike(io.fabric8.openshift.api.model.TLSProfileSpec item) {
    return new io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluentImpl.TlsProfileNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> editTlsProfile() {
    return withNewTlsProfileLike(getTlsProfile());
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> editOrNewTlsProfile() {
    return withNewTlsProfileLike(getTlsProfile() != null ? getTlsProfile(): new io.fabric8.openshift.api.model.TLSProfileSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> editOrNewTlsProfileLike(io.fabric8.openshift.api.model.TLSProfileSpec item) {
    return withNewTlsProfileLike(getTlsProfile() != null ? getTlsProfile(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressControllerStatusFluentImpl that = (IngressControllerStatusFluentImpl) o;
    if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (domain != null ? !domain.equals(that.domain) :that.domain != null) return false;
    if (endpointPublishingStrategy != null ? !endpointPublishingStrategy.equals(that.endpointPublishingStrategy) :that.endpointPublishingStrategy != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (tlsProfile != null ? !tlsProfile.equals(that.tlsProfile) :that.tlsProfile != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableReplicas,  conditions,  domain,  endpointPublishingStrategy,  observedGeneration,  selector,  tlsProfile,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.OperatorConditionFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.operator.v1.OperatorCondition item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IngressControllerStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class EndpointPublishingStrategyNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EndpointPublishingStrategyNestedImpl(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy item) {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder(this);
    }
    io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerStatusFluentImpl.this.withEndpointPublishingStrategy(builder.build());
    }
    public N endEndpointPublishingStrategy() {
      return and();
    }
    
  }
  public class TlsProfileNestedImpl<N> extends io.fabric8.openshift.api.model.TLSProfileSpecFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TlsProfileNestedImpl(io.fabric8.openshift.api.model.TLSProfileSpec item) {
      this.builder = new io.fabric8.openshift.api.model.TLSProfileSpecBuilder(this, item);
    }
    TlsProfileNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TLSProfileSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.TLSProfileSpecBuilder builder;
    public N and() {
      return (N) IngressControllerStatusFluentImpl.this.withTlsProfile(builder.build());
    }
    public N endTlsProfile() {
      return and();
    }
    
  }
  
}