package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AWSLoadBalancerParametersBuilder extends io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluentImpl<io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParameters,io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersBuilder>{
  public AWSLoadBalancerParametersBuilder() {
    this(false);
  }
  public AWSLoadBalancerParametersBuilder(java.lang.Boolean validationEnabled) {
    this(new AWSLoadBalancerParameters(), validationEnabled);
  }
  public AWSLoadBalancerParametersBuilder(io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSLoadBalancerParametersBuilder(io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSLoadBalancerParameters(), validationEnabled);
  }
  public AWSLoadBalancerParametersBuilder(io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParameters instance) {
    this(fluent, instance, false);
  }
  public AWSLoadBalancerParametersBuilder(io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParameters instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClassicLoadBalancer(instance.getClassicLoadBalancer()); 
    fluent.withNetworkLoadBalancer(instance.getNetworkLoadBalancer()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public AWSLoadBalancerParametersBuilder(io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParameters instance) {
    this(instance,false);
  }
  public AWSLoadBalancerParametersBuilder(io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParameters instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClassicLoadBalancer(instance.getClassicLoadBalancer()); 
    this.withNetworkLoadBalancer(instance.getNetworkLoadBalancer()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParametersFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.operator.v1.AWSLoadBalancerParameters build() {
    AWSLoadBalancerParameters buildable = new AWSLoadBalancerParameters(fluent.getClassicLoadBalancer(),fluent.getNetworkLoadBalancer(),fluent.getType());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSLoadBalancerParametersBuilder that = (AWSLoadBalancerParametersBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}