package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StorageStatusBuilder extends io.fabric8.openshift.api.model.operator.v1.StorageStatusFluentImpl<io.fabric8.openshift.api.model.operator.v1.StorageStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.StorageStatus,io.fabric8.openshift.api.model.operator.v1.StorageStatusBuilder> {

    io.fabric8.openshift.api.model.operator.v1.StorageStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public StorageStatusBuilder() {
        this(true);
    }

    public StorageStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new StorageStatus(), validationEnabled);
    }

    public StorageStatusBuilder(io.fabric8.openshift.api.model.operator.v1.StorageStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public StorageStatusBuilder(io.fabric8.openshift.api.model.operator.v1.StorageStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new StorageStatus(), validationEnabled);
    }

    public StorageStatusBuilder(io.fabric8.openshift.api.model.operator.v1.StorageStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.StorageStatus instance) {
        this(fluent, instance, true);
    }

    public StorageStatusBuilder(io.fabric8.openshift.api.model.operator.v1.StorageStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.StorageStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public StorageStatusBuilder(io.fabric8.openshift.api.model.operator.v1.StorageStatus instance) {
        this(instance,true);
    }

    public StorageStatusBuilder(io.fabric8.openshift.api.model.operator.v1.StorageStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.StorageStatus build() {
        StorageStatus buildable = new StorageStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StorageStatusBuilder that = (StorageStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
