package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServerBuilder extends io.fabric8.openshift.api.model.operator.v1.ServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ServerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.Server,io.fabric8.openshift.api.model.operator.v1.ServerBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ServerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServerBuilder() {
        this(true);
    }

    public ServerBuilder(java.lang.Boolean validationEnabled) {
        this(new Server(), validationEnabled);
    }

    public ServerBuilder(io.fabric8.openshift.api.model.operator.v1.ServerFluent<?> fluent) {
        this(fluent, true);
    }

    public ServerBuilder(io.fabric8.openshift.api.model.operator.v1.ServerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Server(), validationEnabled);
    }

    public ServerBuilder(io.fabric8.openshift.api.model.operator.v1.ServerFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.Server instance) {
        this(fluent, instance, true);
    }

    public ServerBuilder(io.fabric8.openshift.api.model.operator.v1.ServerFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.Server instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withForwardPlugin(instance.getForwardPlugin()); 
        fluent.withName(instance.getName()); 
        fluent.withZones(instance.getZones()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServerBuilder(io.fabric8.openshift.api.model.operator.v1.Server instance) {
        this(instance,true);
    }

    public ServerBuilder(io.fabric8.openshift.api.model.operator.v1.Server instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withForwardPlugin(instance.getForwardPlugin()); 
        this.withName(instance.getName()); 
        this.withZones(instance.getZones()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.Server build() {
        Server buildable = new Server(fluent.getForwardPlugin(),fluent.getName(),fluent.getZones());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServerBuilder that = (ServerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
