package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class QuickStartsBuilder extends io.fabric8.openshift.api.model.operator.v1.QuickStartsFluentImpl<io.fabric8.openshift.api.model.operator.v1.QuickStartsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.QuickStarts,io.fabric8.openshift.api.model.operator.v1.QuickStartsBuilder> {

    io.fabric8.openshift.api.model.operator.v1.QuickStartsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public QuickStartsBuilder() {
        this(true);
    }

    public QuickStartsBuilder(java.lang.Boolean validationEnabled) {
        this(new QuickStarts(), validationEnabled);
    }

    public QuickStartsBuilder(io.fabric8.openshift.api.model.operator.v1.QuickStartsFluent<?> fluent) {
        this(fluent, true);
    }

    public QuickStartsBuilder(io.fabric8.openshift.api.model.operator.v1.QuickStartsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new QuickStarts(), validationEnabled);
    }

    public QuickStartsBuilder(io.fabric8.openshift.api.model.operator.v1.QuickStartsFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.QuickStarts instance) {
        this(fluent, instance, true);
    }

    public QuickStartsBuilder(io.fabric8.openshift.api.model.operator.v1.QuickStartsFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.QuickStarts instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDisabled(instance.getDisabled()); 
        this.validationEnabled = validationEnabled; 
    }

    public QuickStartsBuilder(io.fabric8.openshift.api.model.operator.v1.QuickStarts instance) {
        this(instance,true);
    }

    public QuickStartsBuilder(io.fabric8.openshift.api.model.operator.v1.QuickStarts instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDisabled(instance.getDisabled()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.QuickStarts build() {
        QuickStarts buildable = new QuickStarts(fluent.getDisabled());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        QuickStartsBuilder that = (QuickStartsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
