package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicyAuditConfigBuilder extends io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigFluentImpl<io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfig,io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigBuilder> {

    io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PolicyAuditConfigBuilder() {
        this(true);
    }

    public PolicyAuditConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new PolicyAuditConfig(), validationEnabled);
    }

    public PolicyAuditConfigBuilder(io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public PolicyAuditConfigBuilder(io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PolicyAuditConfig(), validationEnabled);
    }

    public PolicyAuditConfigBuilder(io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfig instance) {
        this(fluent, instance, true);
    }

    public PolicyAuditConfigBuilder(io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDestination(instance.getDestination()); 
        fluent.withMaxFileSize(instance.getMaxFileSize()); 
        fluent.withRateLimit(instance.getRateLimit()); 
        fluent.withSyslogFacility(instance.getSyslogFacility()); 
        this.validationEnabled = validationEnabled; 
    }

    public PolicyAuditConfigBuilder(io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfig instance) {
        this(instance,true);
    }

    public PolicyAuditConfigBuilder(io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDestination(instance.getDestination()); 
        this.withMaxFileSize(instance.getMaxFileSize()); 
        this.withRateLimit(instance.getRateLimit()); 
        this.withSyslogFacility(instance.getSyslogFacility()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.PolicyAuditConfig build() {
        PolicyAuditConfig buildable = new PolicyAuditConfig(fluent.getDestination(),fluent.getMaxFileSize(),fluent.getRateLimit(),fluent.getSyslogFacility());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PolicyAuditConfigBuilder that = (PolicyAuditConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
