package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenShiftAPIServerStatusBuilder extends io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatusFluentImpl<io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatus,io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatusBuilder> {

    io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OpenShiftAPIServerStatusBuilder() {
        this(true);
    }

    public OpenShiftAPIServerStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new OpenShiftAPIServerStatus(), validationEnabled);
    }

    public OpenShiftAPIServerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public OpenShiftAPIServerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new OpenShiftAPIServerStatus(), validationEnabled);
    }

    public OpenShiftAPIServerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatus instance) {
        this(fluent, instance, true);
    }

    public OpenShiftAPIServerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenShiftAPIServerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatus instance) {
        this(instance,true);
    }

    public OpenShiftAPIServerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerStatus build() {
        OpenShiftAPIServerStatus buildable = new OpenShiftAPIServerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getLatestAvailableRevision(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenShiftAPIServerStatusBuilder that = (OpenShiftAPIServerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
