package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NodeStatusFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.NodeStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.NodeStatusFluent<A> {

    private java.lang.Integer currentRevision;
    private java.lang.Integer lastFailedCount;
    private java.lang.Integer lastFailedRevision;
    private java.util.List<java.lang.String> lastFailedRevisionErrors = new java.util.ArrayList<java.lang.String>();
    private java.lang.String lastFailedTime;
    private java.lang.String nodeName;
    private java.lang.Integer targetRevision;

    public NodeStatusFluentImpl() {
    }

    public NodeStatusFluentImpl(io.fabric8.openshift.api.model.operator.v1.NodeStatus instance) {
        this.withCurrentRevision(instance.getCurrentRevision()); 
        this.withLastFailedCount(instance.getLastFailedCount()); 
        this.withLastFailedRevision(instance.getLastFailedRevision()); 
        this.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors()); 
        this.withLastFailedTime(instance.getLastFailedTime()); 
        this.withNodeName(instance.getNodeName()); 
        this.withTargetRevision(instance.getTargetRevision()); 
    }

    public java.lang.Integer getCurrentRevision() {
        return this.currentRevision;
    }

    public A withCurrentRevision(java.lang.Integer currentRevision) {
        this.currentRevision=currentRevision; return (A) this;
    }

    public java.lang.Boolean hasCurrentRevision() {
        return this.currentRevision != null;
    }

    public java.lang.Integer getLastFailedCount() {
        return this.lastFailedCount;
    }

    public A withLastFailedCount(java.lang.Integer lastFailedCount) {
        this.lastFailedCount=lastFailedCount; return (A) this;
    }

    public java.lang.Boolean hasLastFailedCount() {
        return this.lastFailedCount != null;
    }

    public java.lang.Integer getLastFailedRevision() {
        return this.lastFailedRevision;
    }

    public A withLastFailedRevision(java.lang.Integer lastFailedRevision) {
        this.lastFailedRevision=lastFailedRevision; return (A) this;
    }

    public java.lang.Boolean hasLastFailedRevision() {
        return this.lastFailedRevision != null;
    }

    public A addToLastFailedRevisionErrors(int index,java.lang.String item) {
        if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new java.util.ArrayList<java.lang.String>();}
        this.lastFailedRevisionErrors.add(index, item);
        return (A)this;
    }

    public A setToLastFailedRevisionErrors(int index,java.lang.String item) {
        if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new java.util.ArrayList<java.lang.String>();}
        this.lastFailedRevisionErrors.set(index, item); return (A)this;
    }

    public A addToLastFailedRevisionErrors(java.lang.String... items) {
        if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.lastFailedRevisionErrors.add(item);} return (A)this;
    }

    public A addAllToLastFailedRevisionErrors(java.util.Collection<java.lang.String> items) {
        if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.lastFailedRevisionErrors.add(item);} return (A)this;
    }

    public A removeFromLastFailedRevisionErrors(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.lastFailedRevisionErrors!= null){ this.lastFailedRevisionErrors.remove(item);}} return (A)this;
    }

    public A removeAllFromLastFailedRevisionErrors(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.lastFailedRevisionErrors!= null){ this.lastFailedRevisionErrors.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getLastFailedRevisionErrors() {
        return this.lastFailedRevisionErrors;
    }

    public java.lang.String getLastFailedRevisionError(int index) {
        return this.lastFailedRevisionErrors.get(index);
    }

    public java.lang.String getFirstLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(0);
    }

    public java.lang.String getLastLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(lastFailedRevisionErrors.size() - 1);
    }

    public java.lang.String getMatchingLastFailedRevisionError(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: lastFailedRevisionErrors) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingLastFailedRevisionError(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: lastFailedRevisionErrors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withLastFailedRevisionErrors(java.util.List<java.lang.String> lastFailedRevisionErrors) {
        if (this.lastFailedRevisionErrors != null) { _visitables.get("lastFailedRevisionErrors").removeAll(this.lastFailedRevisionErrors);}
        if (lastFailedRevisionErrors != null) {this.lastFailedRevisionErrors = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : lastFailedRevisionErrors){this.addToLastFailedRevisionErrors(item);}} else { this.lastFailedRevisionErrors = null;} return (A) this;
    }

    public A withLastFailedRevisionErrors(java.lang.String... lastFailedRevisionErrors) {
        if (this.lastFailedRevisionErrors != null) {this.lastFailedRevisionErrors.clear();}
        if (lastFailedRevisionErrors != null) {for (java.lang.String item :lastFailedRevisionErrors){ this.addToLastFailedRevisionErrors(item);}} return (A) this;
    }

    public java.lang.Boolean hasLastFailedRevisionErrors() {
        return lastFailedRevisionErrors != null && !lastFailedRevisionErrors.isEmpty();
    }

    public A addNewLastFailedRevisionError(java.lang.String arg0) {
        return (A)addToLastFailedRevisionErrors(new String(arg0));
    }

    public java.lang.String getLastFailedTime() {
        return this.lastFailedTime;
    }

    public A withLastFailedTime(java.lang.String lastFailedTime) {
        this.lastFailedTime=lastFailedTime; return (A) this;
    }

    public java.lang.Boolean hasLastFailedTime() {
        return this.lastFailedTime != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLastFailedTime instead.
     */
        public A withNewLastFailedTime(java.lang.String arg0) {
        return (A)withLastFailedTime(new String(arg0));
    }

    public java.lang.String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(java.lang.String nodeName) {
        this.nodeName=nodeName; return (A) this;
    }

    public java.lang.Boolean hasNodeName() {
        return this.nodeName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNodeName instead.
     */
        public A withNewNodeName(java.lang.String arg0) {
        return (A)withNodeName(new String(arg0));
    }

    public java.lang.Integer getTargetRevision() {
        return this.targetRevision;
    }

    public A withTargetRevision(java.lang.Integer targetRevision) {
        this.targetRevision=targetRevision; return (A) this;
    }

    public java.lang.Boolean hasTargetRevision() {
        return this.targetRevision != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NodeStatusFluentImpl that = (NodeStatusFluentImpl) o;
        if (currentRevision != null ? !currentRevision.equals(that.currentRevision) :that.currentRevision != null) return false;
        if (lastFailedCount != null ? !lastFailedCount.equals(that.lastFailedCount) :that.lastFailedCount != null) return false;
        if (lastFailedRevision != null ? !lastFailedRevision.equals(that.lastFailedRevision) :that.lastFailedRevision != null) return false;
        if (lastFailedRevisionErrors != null ? !lastFailedRevisionErrors.equals(that.lastFailedRevisionErrors) :that.lastFailedRevisionErrors != null) return false;
        if (lastFailedTime != null ? !lastFailedTime.equals(that.lastFailedTime) :that.lastFailedTime != null) return false;
        if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
        if (targetRevision != null ? !targetRevision.equals(that.targetRevision) :that.targetRevision != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(currentRevision,  lastFailedCount,  lastFailedRevision,  lastFailedRevisionErrors,  lastFailedTime,  nodeName,  targetRevision,  super.hashCode());
    }

}
