package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NodePlacementFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent<A> {

    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder nodeSelector;
    private java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();

    public NodePlacementFluentImpl() {
    }

    public NodePlacementFluentImpl(io.fabric8.openshift.api.model.operator.v1.NodePlacement instance) {
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withTolerations(instance.getTolerations()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNodeSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getNodeSelector() {
        return this.nodeSelector!=null?this.nodeSelector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildNodeSelector() {
        return this.nodeSelector!=null?this.nodeSelector.build():null;
    }

    public A withNodeSelector(io.fabric8.kubernetes.api.model.LabelSelector nodeSelector) {
        _visitables.get("nodeSelector").remove(this.nodeSelector);
        if (nodeSelector!=null){ this.nodeSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(nodeSelector); _visitables.get("nodeSelector").add(this.nodeSelector);} return (A) this;
    }

    public java.lang.Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent.NodeSelectorNested<A> withNewNodeSelector() {
        return new io.fabric8.openshift.api.model.operator.v1.NodePlacementFluentImpl.NodeSelectorNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent.NodeSelectorNested<A> withNewNodeSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.openshift.api.model.operator.v1.NodePlacementFluentImpl.NodeSelectorNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent.NodeSelectorNested<A> editNodeSelector() {
        return withNewNodeSelectorLike(getNodeSelector());
    }

    public io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent.NodeSelectorNested<A> editOrNewNodeSelector() {
        return withNewNodeSelectorLike(getNodeSelector() != null ? getNodeSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent.NodeSelectorNested<A> editOrNewNodeSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewNodeSelectorLike(getNodeSelector() != null ? getNodeSelector(): item);
    }

    public A addToTolerations(int index,io.fabric8.kubernetes.api.model.Toleration item) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,io.fabric8.kubernetes.api.model.Toleration item) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.Toleration> getTolerations() {
        return this.tolerations;
    }

    public io.fabric8.kubernetes.api.model.Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public io.fabric8.kubernetes.api.model.Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public io.fabric8.kubernetes.api.model.Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.Toleration getMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
        for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
        for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTolerations(java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>(); for (io.fabric8.kubernetes.api.model.Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (io.fabric8.kubernetes.api.model.Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public java.lang.Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(java.lang.String effect,java.lang.String key,java.lang.String operator,java.lang.Long tolerationSeconds,java.lang.String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NodePlacementFluentImpl that = (NodePlacementFluentImpl) o;
        if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(nodeSelector,  tolerations,  super.hashCode());
    }

    public class NodeSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent.NodeSelectorNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent.NodeSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            NodeSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            NodeSelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) NodePlacementFluentImpl.this.withNodeSelector(builder.build());
            }

            public N endNodeSelector() {
                return and();
            }
    }


}
