package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkSpecBuilder extends io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.NetworkSpec,io.fabric8.openshift.api.model.operator.v1.NetworkSpecBuilder> {

    io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NetworkSpecBuilder() {
        this(true);
    }

    public NetworkSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkSpecBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.NetworkSpec instance) {
        this(fluent, instance, true);
    }

    public NetworkSpecBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.NetworkSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAdditionalNetworks(instance.getAdditionalNetworks()); 
        fluent.withClusterNetwork(instance.getClusterNetwork()); 
        fluent.withDefaultNetwork(instance.getDefaultNetwork()); 
        fluent.withDeployKubeProxy(instance.getDeployKubeProxy()); 
        fluent.withDisableMultiNetwork(instance.getDisableMultiNetwork()); 
        fluent.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics()); 
        fluent.withExportNetworkFlows(instance.getExportNetworkFlows()); 
        fluent.withKubeProxyConfig(instance.getKubeProxyConfig()); 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withMigration(instance.getMigration()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withServiceNetwork(instance.getServiceNetwork()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        fluent.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkSpecBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkSpec instance) {
        this(instance,true);
    }

    public NetworkSpecBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAdditionalNetworks(instance.getAdditionalNetworks()); 
        this.withClusterNetwork(instance.getClusterNetwork()); 
        this.withDefaultNetwork(instance.getDefaultNetwork()); 
        this.withDeployKubeProxy(instance.getDeployKubeProxy()); 
        this.withDisableMultiNetwork(instance.getDisableMultiNetwork()); 
        this.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics()); 
        this.withExportNetworkFlows(instance.getExportNetworkFlows()); 
        this.withKubeProxyConfig(instance.getKubeProxyConfig()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withMigration(instance.getMigration()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withServiceNetwork(instance.getServiceNetwork()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpec build() {
        NetworkSpec buildable = new NetworkSpec(fluent.getAdditionalNetworks(),fluent.getClusterNetwork(),fluent.getDefaultNetwork(),fluent.getDeployKubeProxy(),fluent.getDisableMultiNetwork(),fluent.getDisableNetworkDiagnostics(),fluent.getExportNetworkFlows(),fluent.getKubeProxyConfig(),fluent.getLogLevel(),fluent.getManagementState(),fluent.getMigration(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getServiceNetwork(),fluent.getUnsupportedConfigOverrides(),fluent.getUseMultiNetworkPolicy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkSpecBuilder that = (NetworkSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
