package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkBuilder extends io.fabric8.openshift.api.model.operator.v1.NetworkFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.Network,io.fabric8.openshift.api.model.operator.v1.NetworkBuilder> {

    io.fabric8.openshift.api.model.operator.v1.NetworkFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NetworkBuilder() {
        this(true);
    }

    public NetworkBuilder(java.lang.Boolean validationEnabled) {
        this(new Network(), validationEnabled);
    }

    public NetworkBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Network(), validationEnabled);
    }

    public NetworkBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.Network instance) {
        this(fluent, instance, true);
    }

    public NetworkBuilder(io.fabric8.openshift.api.model.operator.v1.NetworkFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.Network instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkBuilder(io.fabric8.openshift.api.model.operator.v1.Network instance) {
        this(instance,true);
    }

    public NetworkBuilder(io.fabric8.openshift.api.model.operator.v1.Network instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.Network build() {
        Network buildable = new Network(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkBuilder that = (NetworkBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
