package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerTuningOptionsBuilder extends io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptions,io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsBuilder> {

    io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IngressControllerTuningOptionsBuilder() {
        this(true);
    }

    public IngressControllerTuningOptionsBuilder(java.lang.Boolean validationEnabled) {
        this(new IngressControllerTuningOptions(), validationEnabled);
    }

    public IngressControllerTuningOptionsBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressControllerTuningOptionsBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IngressControllerTuningOptions(), validationEnabled);
    }

    public IngressControllerTuningOptionsBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptions instance) {
        this(fluent, instance, true);
    }

    public IngressControllerTuningOptionsBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHeaderBufferBytes(instance.getHeaderBufferBytes()); 
        fluent.withHeaderBufferMaxRewriteBytes(instance.getHeaderBufferMaxRewriteBytes()); 
        fluent.withThreadCount(instance.getThreadCount()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerTuningOptionsBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptions instance) {
        this(instance,true);
    }

    public IngressControllerTuningOptionsBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHeaderBufferBytes(instance.getHeaderBufferBytes()); 
        this.withHeaderBufferMaxRewriteBytes(instance.getHeaderBufferMaxRewriteBytes()); 
        this.withThreadCount(instance.getThreadCount()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptions build() {
        IngressControllerTuningOptions buildable = new IngressControllerTuningOptions(fluent.getHeaderBufferBytes(),fluent.getHeaderBufferMaxRewriteBytes(),fluent.getThreadCount());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressControllerTuningOptionsBuilder that = (IngressControllerTuningOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
